/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RecoverableAggregationRepository;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.DefaultExchangeHolder;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.infinispan.commons.api.BasicCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InfinispanAggregationRepository
extends ServiceSupport
implements RecoverableAggregationRepository,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(InfinispanAggregationRepository.class);
    private CamelContext camelContext;
    @Metadata(description="Name of cache", required=true)
    private String cacheName;
    @Metadata(description="Whether or not recovery is enabled", defaultValue="true")
    private boolean useRecovery = true;
    @Metadata(description="Sets an optional dead letter channel which exhausted recovered Exchange should be send to.")
    private String deadLetterUri;
    @Metadata(description="Sets the interval between recovery scans", defaultValue="5000")
    private long recoveryInterval = 5000L;
    @Metadata(description="Sets an optional limit of the number of redelivery attempt of recovered Exchange should be attempted, before its exhausted. When this limit is hit, then the Exchange is moved to the dead letter channel.", defaultValue="3")
    private int maximumRedeliveries = 3;
    @Metadata(label="advanced", description="Whether headers on the Exchange that are Java objects and Serializable should be included and saved to the repository")
    private boolean allowSerializedHeaders;

    public InfinispanAggregationRepository() {
    }

    protected InfinispanAggregationRepository(String cacheName) {
        this.cacheName = cacheName;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public Exchange add(CamelContext camelContext, String key, Exchange exchange) {
        LOG.trace("Adding an Exchange with ID {} for key {} in a thread-safe manner.", (Object)exchange.getExchangeId(), (Object)key);
        DefaultExchangeHolder newHolder = DefaultExchangeHolder.marshal(exchange, true, this.allowSerializedHeaders);
        DefaultExchangeHolder oldHolder = this.getCache().put(key, newHolder);
        return this.unmarshallExchange(camelContext, oldHolder);
    }

    @Override
    public Exchange get(CamelContext camelContext, String key) {
        return this.unmarshallExchange(camelContext, (DefaultExchangeHolder)this.getCache().get(key));
    }

    @Override
    public void remove(CamelContext camelContext, String key, Exchange exchange) {
        LOG.trace("Removing an exchange with ID {} for key {}", (Object)exchange.getExchangeId(), (Object)key);
        this.getCache().remove(key);
    }

    @Override
    public void confirm(CamelContext camelContext, String exchangeId) {
        LOG.trace("Confirming an exchange with ID {}.", (Object)exchangeId);
        this.getCache().remove(exchangeId);
    }

    @Override
    public Set<String> getKeys() {
        return Collections.unmodifiableSet(this.getCache().keySet());
    }

    @Override
    public Set<String> scan(CamelContext camelContext) {
        LOG.trace("Scanning for exchanges to recover in {} context", (Object)camelContext.getName());
        Set<String> scanned = Collections.unmodifiableSet(this.getCache().keySet());
        LOG.trace("Found {} keys for exchanges to recover in {} context", (Object)scanned.size(), (Object)camelContext.getName());
        return scanned;
    }

    @Override
    public Exchange recover(CamelContext camelContext, String exchangeId) {
        LOG.trace("Recovering an Exchange with ID {}.", (Object)exchangeId);
        return this.useRecovery ? this.unmarshallExchange(camelContext, (DefaultExchangeHolder)this.getCache().get(exchangeId)) : null;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    @Override
    public void setRecoveryInterval(long interval, TimeUnit timeUnit) {
        this.recoveryInterval = timeUnit.toMillis(interval);
    }

    @Override
    public long getRecoveryInterval() {
        return this.recoveryInterval;
    }

    @Override
    public void setRecoveryInterval(long interval) {
        this.recoveryInterval = interval;
    }

    @Override
    public boolean isUseRecovery() {
        return this.useRecovery;
    }

    @Override
    public void setUseRecovery(boolean useRecovery) {
        this.useRecovery = useRecovery;
    }

    @Override
    public int getMaximumRedeliveries() {
        return this.maximumRedeliveries;
    }

    @Override
    public void setMaximumRedeliveries(int maximumRedeliveries) {
        this.maximumRedeliveries = maximumRedeliveries;
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.cacheName, "cacheName", this);
        if (this.maximumRedeliveries < 0) {
            throw new IllegalArgumentException("Maximum redelivery retries must be zero or a positive integer.");
        }
        if (this.recoveryInterval < 0L) {
            throw new IllegalArgumentException("Recovery interval must be zero or a positive integer.");
        }
    }

    protected Exchange unmarshallExchange(CamelContext camelContext, DefaultExchangeHolder holder) {
        DefaultExchange exchange = null;
        if (holder != null) {
            exchange = new DefaultExchange(camelContext);
            DefaultExchangeHolder.unmarshal(exchange, holder);
        }
        return exchange;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public String getDeadLetterUri() {
        return this.deadLetterUri;
    }

    @Override
    public void setDeadLetterUri(String deadLetterUri) {
        this.deadLetterUri = deadLetterUri;
    }

    public boolean isAllowSerializedHeaders() {
        return this.allowSerializedHeaders;
    }

    public void setAllowSerializedHeaders(boolean allowSerializedHeaders) {
        this.allowSerializedHeaders = allowSerializedHeaders;
    }

    protected abstract BasicCache<String, DefaultExchangeHolder> getCache();
}

