/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.remote;

import java.util.HashSet;
import java.util.Set;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.component.infinispan.InfinispanConsumer;
import org.apache.camel.component.infinispan.InfinispanEndpoint;
import org.apache.camel.component.infinispan.InfinispanEventListener;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteConfiguration;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteEventListener;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteManager;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteUtil;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.query.api.continuous.ContinuousQuery;
import org.infinispan.query.api.continuous.ContinuousQueryListener;
import org.infinispan.query.dsl.Query;

public class InfinispanRemoteConsumer
extends InfinispanConsumer<RemoteCacheManager, InfinispanRemoteManager, InfinispanRemoteConfiguration> {
    private Service handler;

    public InfinispanRemoteConsumer(InfinispanEndpoint endpoint, Processor processor, String cacheName, InfinispanRemoteManager manager, InfinispanRemoteConfiguration configuration) {
        super(endpoint, processor, cacheName, manager, configuration);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.handler = ((InfinispanRemoteConfiguration)this.getConfiguration()).hasQueryBuilder() ? new ContinuousQueryHandler() : new ConsumerHandler();
        ServiceHelper.startService(this.handler);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService(this.handler);
    }

    private class ContinuousQueryHandler
    extends ServiceSupport
    implements ContinuousQueryListener<Object, Object> {
        private ContinuousQuery<Object, Object> continuousQuery;

        private ContinuousQueryHandler() {
        }

        @Override
        public void resultJoining(Object key, Object value) {
            InfinispanRemoteConsumer.this.processEvent("CacheEntryJoining", InfinispanRemoteConsumer.this.cacheName, key, value, null);
        }

        @Override
        public void resultUpdated(Object key, Object value) {
            InfinispanRemoteConsumer.this.processEvent("CacheEntryUpdated", InfinispanRemoteConsumer.this.cacheName, key, value, null);
        }

        @Override
        public void resultLeaving(Object key) {
            InfinispanRemoteConsumer.this.processEvent("CacheEntryLeaving", InfinispanRemoteConsumer.this.cacheName, key, null, null);
        }

        @Override
        public void doStart() {
            RemoteCache remoteCache = InfinispanRemoteConsumer.this.getCache(RemoteCache.class);
            Query<?> query = InfinispanRemoteUtil.buildQuery(((InfinispanRemoteConfiguration)InfinispanRemoteConsumer.this.getConfiguration()).getQueryBuilder(), (RemoteCache<Object, Object>)remoteCache);
            this.continuousQuery = Search.getContinuousQuery(remoteCache);
            this.continuousQuery.addContinuousQueryListener(query, this);
        }

        @Override
        public void doStop() {
            if (this.continuousQuery != null) {
                this.continuousQuery.removeAllListeners();
            }
        }
    }

    private class ConsumerHandler
    extends ServiceSupport {
        private InfinispanEventListener<ClientEvent.Type> listener;

        private ConsumerHandler() {
        }

        @Override
        public void doStart() {
            RemoteCache cache = InfinispanRemoteConsumer.this.getCache(RemoteCache.class);
            InfinispanRemoteConfiguration configuration = (InfinispanRemoteConfiguration)InfinispanRemoteConsumer.this.getConfiguration();
            this.listener = configuration.getCustomListener();
            if (this.listener == null) {
                HashSet<ClientEvent.Type> events = new HashSet<ClientEvent.Type>();
                if (configuration.getEventTypes() != null) {
                    String eventTypes = configuration.getEventTypes();
                    for (String event : eventTypes.split(",")) {
                        events.add(ClientEvent.Type.valueOf(event));
                    }
                }
                this.listener = new InfinispanRemoteEventListener((Set<ClientEvent.Type>)events);
            }
            this.listener.setCacheName(cache.getName());
            this.listener.setEventProcessor(InfinispanRemoteConsumer.this);
            cache.addClientListener(this.listener);
        }

        @Override
        public void doStop() {
            InfinispanRemoteConsumer.this.getCache(RemoteCache.class).removeClientListener(this.listener);
        }
    }
}

