/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.infinispan.client.hotrod.configuration.AbstractSecurityConfigurationChildBuilder;
import org.infinispan.client.hotrod.configuration.AuthenticationConfiguration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.SaslQop;
import org.infinispan.client.hotrod.configuration.SaslStrength;
import org.infinispan.client.hotrod.configuration.SecurityConfigurationBuilder;
import org.infinispan.client.hotrod.impl.ConfigurationProperties;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.security.BasicCallbackHandler;
import org.infinispan.client.hotrod.security.TokenCallbackHandler;
import org.infinispan.client.hotrod.security.VoidCallbackHandler;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;

public class AuthenticationConfigurationBuilder
extends AbstractSecurityConfigurationChildBuilder
implements Builder<AuthenticationConfiguration> {
    public static final String DEFAULT_REALM = "default";
    public static final String DEFAULT_SERVER_NAME = "infinispan";
    public static final String DEFAULT_MECHANISM = "SCRAM-SHA-256";
    private static final String EXTERNAL_MECH = "EXTERNAL";
    private static final String OAUTHBEARER_MECH = "OAUTHBEARER";
    private static final String GSSAPI_MECH = "GSSAPI";
    private static final String GS2_KRB5_MECH = "GS2-KRB5";
    private CallbackHandler callbackHandler;
    private boolean enabled = false;
    private String serverName;
    private Map<String, String> saslProperties = new HashMap<String, String>();
    private String saslMechanism;
    private Subject clientSubject;
    private String username;
    private char[] password;
    private String realm;
    private String token;

    public AuthenticationConfigurationBuilder(SecurityConfigurationBuilder builder) {
        super(builder);
    }

    @Override
    public AttributeSet attributes() {
        return AttributeSet.EMPTY;
    }

    public AuthenticationConfigurationBuilder callbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
        return this;
    }

    public AuthenticationConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public AuthenticationConfigurationBuilder enable() {
        this.enabled = true;
        return this;
    }

    public AuthenticationConfigurationBuilder disable() {
        this.enabled = false;
        return this;
    }

    public AuthenticationConfigurationBuilder saslMechanism(String saslMechanism) {
        this.saslMechanism = saslMechanism;
        return this.enable();
    }

    public AuthenticationConfigurationBuilder saslProperties(Map<String, String> saslProperties) {
        this.saslProperties = saslProperties;
        return this.enable();
    }

    public AuthenticationConfigurationBuilder saslQop(SaslQop ... qop) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < qop.length; ++i) {
            if (i > 0) {
                s.append(",");
            }
            s.append(qop[i].toString());
        }
        this.saslProperties.put("javax.security.sasl.qop", s.toString());
        return this.enable();
    }

    public AuthenticationConfigurationBuilder saslStrength(SaslStrength ... strength) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < strength.length; ++i) {
            if (i > 0) {
                s.append(",");
            }
            s.append(strength[i].toString());
        }
        this.saslProperties.put("javax.security.sasl.strength", s.toString());
        return this.enable();
    }

    public AuthenticationConfigurationBuilder serverName(String serverName) {
        this.serverName = serverName;
        return this.enable();
    }

    public AuthenticationConfigurationBuilder clientSubject(Subject clientSubject) {
        this.clientSubject = clientSubject;
        return this.enable();
    }

    public AuthenticationConfigurationBuilder username(String username) {
        this.username = username;
        return this.enable();
    }

    public AuthenticationConfigurationBuilder password(String password) {
        this.password = password != null ? password.toCharArray() : null;
        return this.enable();
    }

    public AuthenticationConfigurationBuilder password(char[] password) {
        this.password = password;
        return this.enable();
    }

    public AuthenticationConfigurationBuilder realm(String realm) {
        this.realm = realm;
        return this.enable();
    }

    public AuthenticationConfigurationBuilder token(String token) {
        this.token = token;
        return this.enable();
    }

    @Override
    public AuthenticationConfiguration create() {
        String mech = this.saslMechanism == null ? DEFAULT_MECHANISM : this.saslMechanism;
        CallbackHandler cbh = this.callbackHandler;
        if (cbh == null) {
            if (OAUTHBEARER_MECH.equals(mech)) {
                cbh = new TokenCallbackHandler(this.token);
            } else if (this.username != null) {
                cbh = new BasicCallbackHandler(this.username, this.realm != null ? this.realm : DEFAULT_REALM, this.password);
            } else if (EXTERNAL_MECH.equals(mech) || GSSAPI_MECH.equals(mech) || GS2_KRB5_MECH.equals(mech)) {
                cbh = new VoidCallbackHandler();
            }
        }
        return new AuthenticationConfiguration(cbh, this.clientSubject, this.enabled, mech, this.saslProperties, this.serverName != null ? this.serverName : DEFAULT_SERVER_NAME);
    }

    @Override
    public Builder<?> read(AuthenticationConfiguration template, Combine combine) {
        this.callbackHandler = template.callbackHandler();
        this.clientSubject = template.clientSubject();
        this.enabled = template.enabled();
        this.saslMechanism = template.saslMechanism();
        this.saslProperties = template.saslProperties();
        this.serverName = template.serverName();
        return this;
    }

    @Override
    public void validate() {
        if (this.enabled) {
            if (this.callbackHandler == null && this.clientSubject == null && this.username == null && this.token == null && !EXTERNAL_MECH.equals(this.saslMechanism)) {
                throw Log.HOTROD.invalidAuthenticationConfiguration();
            }
            if (OAUTHBEARER_MECH.equals(this.saslMechanism) && this.callbackHandler == null && this.token == null) {
                throw Log.HOTROD.oauthBearerWithoutToken();
            }
            if (this.callbackHandler != null && (this.username != null || this.token != null)) {
                throw Log.HOTROD.callbackHandlerAndUsernameMutuallyExclusive();
            }
        }
    }

    @Override
    public ConfigurationBuilder withProperties(Properties properties) {
        Map<String, String> saslProperties;
        Object prop;
        TypedProperties typed = TypedProperties.toTypedProperties(properties);
        if (typed.containsKey("infinispan.client.hotrod.sasl_mechanism")) {
            this.saslMechanism(typed.getProperty("infinispan.client.hotrod.sasl_mechanism", this.saslMechanism, true));
        }
        if ((prop = typed.get("infinispan.client.hotrod.auth_callback_handler")) instanceof String) {
            String cbhClassName = StringPropertyReplacer.replaceProperties((String)prop);
            CallbackHandler handler = (CallbackHandler)Util.getInstance(cbhClassName, AuthenticationConfigurationBuilder.class.getClassLoader());
            this.callbackHandler(handler);
        } else if (prop instanceof CallbackHandler) {
            this.callbackHandler((CallbackHandler)prop);
        }
        if (typed.containsKey("infinispan.client.hotrod.auth_username")) {
            this.username(typed.getProperty("infinispan.client.hotrod.auth_username", this.username, true));
        }
        if (typed.containsKey("infinispan.client.hotrod.auth_password")) {
            this.password(typed.getProperty("infinispan.client.hotrod.auth_password", null, true));
        }
        if (typed.containsKey("infinispan.client.hotrod.auth_token")) {
            this.token(typed.getProperty("infinispan.client.hotrod.auth_token", this.token, true));
        }
        if (typed.containsKey("infinispan.client.hotrod.auth_realm")) {
            this.realm(typed.getProperty("infinispan.client.hotrod.auth_realm", this.realm, true));
        }
        if (typed.containsKey("infinispan.client.hotrod.auth_server_name")) {
            this.serverName(typed.getProperty("infinispan.client.hotrod.auth_server_name", this.serverName, true));
        }
        if (typed.containsKey("infinispan.client.hotrod.auth_client_subject")) {
            this.clientSubject((Subject)typed.get("infinispan.client.hotrod.auth_client_subject"));
        }
        if (!(saslProperties = typed.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("infinispan.client.hotrod.sasl_properties")).collect(Collectors.toMap(e -> ConfigurationProperties.SASL_PROPERTIES_PREFIX_REGEX.matcher((String)e.getKey()).replaceFirst(""), e -> StringPropertyReplacer.replaceProperties((String)e.getValue())))).isEmpty()) {
            this.saslProperties(saslProperties);
        }
        if (typed.containsKey("infinispan.client.hotrod.use_auth")) {
            this.enabled(typed.getBooleanProperty("infinispan.client.hotrod.use_auth", this.enabled, true));
        }
        return this.builder.getBuilder();
    }
}

