/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import java.util.Properties;
import org.infinispan.client.hotrod.configuration.AbstractConfigurationChildBuilder;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ExecutorFactoryConfiguration;
import org.infinispan.commons.configuration.AbstractTypedPropertiesConfiguration;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;

public class ExecutorFactoryConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<ExecutorFactoryConfiguration> {
    private final AttributeSet attributes = ExecutorFactoryConfiguration.attributeDefinitionSet();

    ExecutorFactoryConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    @Override
    public AttributeSet attributes() {
        return this.attributes;
    }

    public ExecutorFactoryConfigurationBuilder factoryClass(Class<? extends ExecutorFactory> factoryClass) {
        this.attributes.attribute(ExecutorFactoryConfiguration.FACTORY_CLASS).set(factoryClass);
        return this;
    }

    public ExecutorFactoryConfigurationBuilder factoryClass(String factoryClass) {
        return this.factoryClass(Util.loadClass(factoryClass, this.builder.classLoader()));
    }

    public ExecutorFactoryConfigurationBuilder factory(ExecutorFactory factory) {
        this.attributes.attribute(ExecutorFactoryConfiguration.FACTORY).set(factory);
        return this;
    }

    public ExecutorFactoryConfigurationBuilder addExecutorProperty(String key, String value) {
        this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).get().put(key, value);
        return this;
    }

    public ExecutorFactoryConfigurationBuilder withExecutorProperties(Properties props) {
        this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).set(TypedProperties.toTypedProperties(props));
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public ExecutorFactoryConfiguration create() {
        return new ExecutorFactoryConfiguration(this.attributes.protect());
    }

    public ExecutorFactoryConfigurationBuilder read(ExecutorFactoryConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public String toString() {
        return "ExecutorFactoryConfigurationBuilder [attributes=" + String.valueOf(this.attributes) + "]";
    }
}

