/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import jakarta.transaction.TransactionManager;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.Scanner;
import java.util.function.Consumer;
import org.infinispan.client.hotrod.DefaultTemplate;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.configuration.RemoteCacheConfiguration;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.near.NearCacheFactory;
import org.infinispan.client.hotrod.transaction.lookup.GenericTransactionManagerLookup;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;

public class RemoteCacheConfigurationBuilder
implements Builder<RemoteCacheConfiguration> {
    private final ConfigurationBuilder builder;
    private final AttributeSet attributes;

    RemoteCacheConfigurationBuilder(ConfigurationBuilder builder, String name) {
        this.builder = builder;
        this.attributes = RemoteCacheConfiguration.attributeDefinitionSet();
        this.attributes.attribute(RemoteCacheConfiguration.NAME).set(name);
    }

    @Override
    public AttributeSet attributes() {
        return this.attributes;
    }

    public RemoteCacheConfigurationBuilder forceReturnValues(boolean forceReturnValues) {
        this.attributes.attribute(RemoteCacheConfiguration.FORCE_RETURN_VALUES).set(forceReturnValues);
        return this;
    }

    public RemoteCacheConfigurationBuilder nearCacheMode(NearCacheMode mode) {
        this.attributes.attribute(RemoteCacheConfiguration.NEAR_CACHE_MODE).set(mode);
        return this;
    }

    public RemoteCacheConfigurationBuilder nearCacheMaxEntries(int maxEntries) {
        this.attributes.attribute(RemoteCacheConfiguration.NEAR_CACHE_MAX_ENTRIES).set(maxEntries);
        return this;
    }

    public RemoteCacheConfigurationBuilder nearCacheUseBloomFilter(boolean enable) {
        this.attributes.attribute(RemoteCacheConfiguration.NEAR_CACHE_BLOOM_FILTER).set(enable);
        return this;
    }

    public RemoteCacheConfigurationBuilder nearCacheFactory(NearCacheFactory factory) {
        this.attributes.attribute(RemoteCacheConfiguration.NEAR_CACHE_FACTORY).set(factory);
        return this;
    }

    public RemoteCacheConfigurationBuilder configuration(String configuration) {
        this.attributes.attribute(RemoteCacheConfiguration.CONFIGURATION).set(configuration);
        return this;
    }

    public RemoteCacheConfigurationBuilder configurationURI(URI uri) {
        URL url = !uri.isAbsolute() ? FileLookupFactory.newInstance().lookupFileLocation(uri.toString(), this.getClass().getClassLoader()) : uri.toURL();
        Scanner scanner = new Scanner(url.openStream(), StandardCharsets.UTF_8.toString()).useDelimiter("\\A");
        try {
            RemoteCacheConfigurationBuilder remoteCacheConfigurationBuilder = this.configuration(scanner.next());
            if (scanner != null) {
                scanner.close();
            }
            return remoteCacheConfigurationBuilder;
        }
        catch (Throwable throwable) {
            try {
                if (scanner != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new CacheConfigurationException(e);
            }
        }
    }

    public RemoteCacheConfigurationBuilder templateName(String templateName) {
        this.attributes.attribute(RemoteCacheConfiguration.TEMPLATE_NAME).set(templateName);
        return this;
    }

    public RemoteCacheConfigurationBuilder templateName(DefaultTemplate template) {
        this.attributes.attribute(RemoteCacheConfiguration.TEMPLATE_NAME).set(template.getTemplateName());
        return this;
    }

    public RemoteCacheConfigurationBuilder transactionMode(TransactionMode mode) {
        this.attributes.attribute(RemoteCacheConfiguration.TRANSACTION_MODE).set(mode);
        return this;
    }

    public RemoteCacheConfigurationBuilder marshaller(String className) {
        this.marshaller(Util.loadClass(className, Thread.currentThread().getContextClassLoader()));
        return this;
    }

    public RemoteCacheConfigurationBuilder marshaller(Class<? extends Marshaller> marshallerClass) {
        this.attributes.attribute(RemoteCacheConfiguration.MARSHALLER_CLASS).set(marshallerClass);
        return this;
    }

    public RemoteCacheConfigurationBuilder marshaller(Marshaller marshaller) {
        this.attributes.attribute(RemoteCacheConfiguration.MARSHALLER).set(marshaller);
        return this;
    }

    @Deprecated(forRemoval=true, since="12.0")
    public RemoteCacheConfigurationBuilder transactionManager(TransactionManager manager) {
        return this.transactionManagerLookup(() -> manager);
    }

    public RemoteCacheConfigurationBuilder transactionManagerLookup(TransactionManagerLookup lookup) {
        this.attributes.attribute(RemoteCacheConfiguration.TRANSACTION_MANAGER).set(lookup);
        return this;
    }

    @Override
    public void validate() {
        if (this.attributes.attribute(RemoteCacheConfiguration.CONFIGURATION).isModified() && this.attributes.attribute(RemoteCacheConfiguration.TEMPLATE_NAME).isModified()) {
            throw Log.HOTROD.remoteCacheTemplateNameXorConfiguration(this.attributes.attribute(RemoteCacheConfiguration.NAME).get());
        }
        if (this.attributes.attribute(RemoteCacheConfiguration.TRANSACTION_MODE).get() == null) {
            throw Log.HOTROD.invalidTransactionMode();
        }
        if (this.attributes.attribute(RemoteCacheConfiguration.TRANSACTION_MANAGER).get() == null) {
            throw Log.HOTROD.invalidTransactionManagerLookup();
        }
    }

    @Override
    public RemoteCacheConfiguration create() {
        return new RemoteCacheConfiguration(this.attributes.protect());
    }

    @Override
    public Builder<?> read(RemoteCacheConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public ConfigurationBuilder withProperties(Properties properties) {
        TypedProperties typed = TypedProperties.toTypedProperties(properties);
        this.findCacheProperty(typed, ".configuration", this::configuration);
        this.findCacheProperty(typed, ".configuration_uri", v -> this.configurationURI(URI.create(v)));
        this.findCacheProperty(typed, ".template_name", this::templateName);
        this.findCacheProperty(typed, ".force_return_values", v -> this.forceReturnValues(Boolean.parseBoolean(v)));
        this.findCacheProperty(typed, ".near_cache.mode", v -> this.nearCacheMode(NearCacheMode.valueOf(v)));
        this.findCacheProperty(typed, ".near_cache.max_entries", v -> this.nearCacheMaxEntries(Integer.parseInt(v)));
        this.findCacheProperty(typed, ".near_cache.bloom_filter", v -> this.nearCacheUseBloomFilter(Boolean.parseBoolean(v)));
        this.findCacheProperty(typed, ".near_cache.factory", v -> this.nearCacheFactory((NearCacheFactory)Util.getInstance(Util.loadClass(v, RemoteCacheConfigurationBuilder.class.getClassLoader()))));
        this.findCacheProperty(typed, ".transaction.transaction_mode", v -> this.transactionMode(TransactionMode.valueOf(v)));
        this.findCacheProperty(typed, ".transaction.transaction_manager_lookup", this::transactionManagerLookupClass);
        this.findCacheProperty(typed, ".marshaller", this::marshaller);
        return this.builder;
    }

    private void transactionManagerLookupClass(String lookupClass) {
        GenericTransactionManagerLookup lookup = lookupClass == null || GenericTransactionManagerLookup.class.getName().equals(lookupClass) ? GenericTransactionManagerLookup.getInstance() : (TransactionManagerLookup)Util.getInstance(Util.loadClass(lookupClass, RemoteCacheConfigurationBuilder.class.getClassLoader()));
        this.transactionManagerLookup(lookup);
    }

    private void findCacheProperty(TypedProperties properties, String name, Consumer<String> consumer) {
        String cacheName = this.attributes.attribute(RemoteCacheConfiguration.NAME).get();
        String value = null;
        if (properties.containsKey("infinispan.client.hotrod.cache." + cacheName + name)) {
            value = properties.getProperty("infinispan.client.hotrod.cache." + cacheName + name, true);
        } else if (properties.containsKey("infinispan.client.hotrod.cache.[" + cacheName + "]" + name)) {
            value = properties.getProperty("infinispan.client.hotrod.cache.[" + cacheName + "]" + name, true);
        }
        if (value != null) {
            consumer.accept(value);
        }
    }
}

