/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import java.util.Properties;
import org.infinispan.client.hotrod.configuration.AbstractConfigurationChildBuilder;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.StatisticsConfiguration;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.util.TypedProperties;

public class StatisticsConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<StatisticsConfiguration> {
    AttributeSet attributes = StatisticsConfiguration.attributeDefinitionSet();

    StatisticsConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    @Override
    public AttributeSet attributes() {
        return AttributeSet.EMPTY;
    }

    public StatisticsConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(StatisticsConfiguration.ENABLED).set(enabled);
        return this;
    }

    public StatisticsConfigurationBuilder enable() {
        return this.enabled(true);
    }

    public StatisticsConfigurationBuilder disable() {
        return this.enabled(false);
    }

    public StatisticsConfigurationBuilder jmxEnabled(boolean enabled) {
        this.attributes.attribute(StatisticsConfiguration.JMX_ENABLED).set(enabled);
        return this;
    }

    public StatisticsConfigurationBuilder jmxEnable() {
        return this.jmxEnabled(true);
    }

    public StatisticsConfigurationBuilder jmxDisable() {
        return this.jmxEnabled(false);
    }

    public StatisticsConfigurationBuilder jmxDomain(String jmxDomain) {
        this.attributes.attribute(StatisticsConfiguration.JMX_DOMAIN).set(jmxDomain);
        return this;
    }

    public StatisticsConfigurationBuilder jmxName(String jmxName) {
        this.attributes.attribute(StatisticsConfiguration.JMX_NAME).set(jmxName);
        return this;
    }

    public StatisticsConfigurationBuilder mBeanServerLookup(MBeanServerLookup mBeanServerLookupInstance) {
        this.attributes.attribute(StatisticsConfiguration.MBEAN_SERVER_LOOKUP).set(mBeanServerLookupInstance);
        return this;
    }

    @Override
    public StatisticsConfiguration create() {
        return new StatisticsConfiguration(this.attributes.protect());
    }

    @Override
    public Builder<?> read(StatisticsConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    @Override
    public ConfigurationBuilder withProperties(Properties properties) {
        TypedProperties typed = TypedProperties.toTypedProperties(properties);
        this.enabled(typed.getBooleanProperty("infinispan.client.hotrod.statistics", StatisticsConfiguration.ENABLED.getDefaultValue()));
        this.jmxEnabled(typed.getBooleanProperty("infinispan.client.hotrod.jmx", StatisticsConfiguration.JMX_ENABLED.getDefaultValue()));
        this.jmxDomain(typed.getProperty("infinispan.client.hotrod.jmx_domain", StatisticsConfiguration.JMX_DOMAIN.getDefaultValue()));
        this.jmxName(typed.getProperty("infinispan.client.hotrod.jmx_name", StatisticsConfiguration.JMX_NAME.getDefaultValue()));
        return this.builder;
    }
}

