/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.operation;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.counter.operation.BaseCounterOperation;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;

public class SetOperation
extends BaseCounterOperation<Long> {
    private static final Log commonsLog = LogFactory.getLog(SetOperation.class, Log.class);
    private final long value;

    public SetOperation(ChannelFactory channelFactory, AtomicReference<ClientTopology> topologyId, Configuration cfg, String counterName, long value, boolean useConsistentHash) {
        super((short)127, (short)128, channelFactory, topologyId, cfg, counterName, useConsistentHash);
        this.value = value;
    }

    @Override
    protected void executeOperation(Channel channel) {
        ByteBuf buf = this.getHeaderAndCounterNameBufferAndRead(channel, 8);
        buf.writeLong(this.value);
        channel.writeAndFlush(buf);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        this.checkStatus(status);
        this.assertBoundaries(status);
        assert (status == 0);
        this.complete(buf.readLong());
    }

    private void assertBoundaries(short status) {
        if (status == 4) {
            if (this.value > 0L) {
                throw commonsLog.counterOurOfBounds("Upper bound");
            }
            throw commonsLog.counterOurOfBounds("Lower bound");
        }
    }
}

