/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.operations.AbstractKeyOperation;
import org.infinispan.client.hotrod.impl.protocol.ChannelOutputStream;
import org.infinispan.client.hotrod.impl.protocol.ChannelOutputStreamListener;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.telemetry.impl.TelemetryService;

@Immutable
public class PutStreamOperation
extends AbstractKeyOperation<OutputStream>
implements ChannelOutputStreamListener {
    static final long VERSION_PUT = 0L;
    static final long VERSION_PUT_IF_ABSENT = -1L;
    private final long version;
    private final long lifespan;
    private final long maxIdle;
    private final TimeUnit lifespanTimeUnit;
    private final TimeUnit maxIdleTimeUnit;
    private final CompletableFuture<Void> closeFuture = new CompletableFuture();

    public PutStreamOperation(Codec codec, ChannelFactory channelFactory, Object key, byte[] keyBytes, byte[] cacheName, AtomicReference<ClientTopology> clientTopology, int flags, Configuration cfg, long version, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit, ClientStatistics clientStatistics, TelemetryService telemetryService) {
        super((short)57, (short)58, codec, channelFactory, key, keyBytes, cacheName, clientTopology, flags, cfg, null, clientStatistics, telemetryService);
        this.version = version;
        this.lifespan = lifespan;
        this.maxIdle = maxIdle;
        this.lifespanTimeUnit = lifespanTimeUnit;
        this.maxIdleTimeUnit = maxIdleTimeUnit;
    }

    @Override
    public void executeOperation(Channel channel) {
        this.scheduleRead(channel);
        ByteBuf buf = channel.alloc().buffer(this.codec.estimateHeaderSize(this.header) + ByteBufUtil.estimateArraySize(this.keyBytes) + this.codec.estimateExpirationSize(this.lifespan, this.lifespanTimeUnit, this.maxIdle, this.maxIdleTimeUnit) + 8);
        this.codec.writeHeader(buf, this.header);
        ByteBufUtil.writeArray(buf, this.keyBytes);
        this.codec.writeExpirationParams(buf, this.lifespan, this.lifespanTimeUnit, this.maxIdle, this.maxIdleTimeUnit);
        buf.writeLong(this.version);
        channel.writeAndFlush(buf);
        this.complete(new ChannelOutputStream(channel, this));
    }

    @Override
    public void releaseChannel(Channel channel) {
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        this.closeFuture.completeExceptionally(ex);
        return super.completeExceptionally(ex);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (HotRodConstants.isSuccess(status) || HotRodConstants.isNotExecuted(status) && this.version != 0L) {
            if (HotRodConstants.isSuccess(status)) {
                this.statsDataStore();
            }
            this.closeFuture.complete(null);
        } else {
            this.closeFuture.completeExceptionally(new InvalidResponseException("Unexpected response status: " + Integer.toHexString(status)));
        }
    }

    @Override
    public void onError(Channel channel, Throwable error) {
        this.completeExceptionally(error);
    }

    @Override
    public void onClose(Channel channel) throws IOException {
        try {
            this.closeFuture.join();
        }
        catch (CompletionException e) {
            throw new IOException(e.getCause());
        }
        finally {
            if (channel.isActive()) {
                this.channelFactory.releaseChannel(channel);
            }
        }
    }
}

