/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.operations.QuerySerializer;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.query.RemoteQuery;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.client.impl.BaseQueryResponse;
import org.infinispan.query.remote.client.impl.QueryRequest;

public final class QueryOperation<T>
extends RetryOnFailureOperation<BaseQueryResponse<T>> {
    private final RemoteQuery<T> remoteQuery;
    private final QuerySerializer querySerializer;
    private final boolean withHitCount;

    public QueryOperation(Codec codec, ChannelFactory channelFactory, byte[] cacheName, AtomicReference<ClientTopology> clientTopology, int flags, Configuration cfg, RemoteQuery<T> remoteQuery, DataFormat dataFormat, boolean withHitCount) {
        super((short)31, (short)32, codec, channelFactory, cacheName, clientTopology, flags, cfg, dataFormat, null);
        this.remoteQuery = remoteQuery;
        this.querySerializer = QuerySerializer.findByMediaType(dataFormat.getValueType());
        this.withHitCount = withHitCount;
    }

    @Override
    protected void executeOperation(Channel channel) {
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.setQueryString(this.remoteQuery.getQueryString());
        if (this.remoteQuery.getStartOffset() > 0L) {
            queryRequest.setStartOffset(this.remoteQuery.getStartOffset());
        }
        if (this.remoteQuery.getMaxResults() >= 0) {
            queryRequest.setMaxResults(this.remoteQuery.getMaxResults());
        }
        if (this.withHitCount) {
            if (this.remoteQuery.hitCountAccuracy() != null) {
                queryRequest.hitCountAccuracy(this.remoteQuery.hitCountAccuracy());
            }
        } else {
            queryRequest.hitCountAccuracy(1);
        }
        queryRequest.setNamedParameters(this.getNamedParameters());
        queryRequest.setLocal(this.remoteQuery.isLocal());
        byte[] requestBytes = this.querySerializer.serializeQueryRequest(this.remoteQuery, queryRequest);
        this.scheduleRead(channel);
        ByteBuf buf = channel.alloc().buffer(this.codec.estimateHeaderSize(this.header) + ByteBufUtil.estimateVIntSize(requestBytes.length));
        this.codec.writeHeader(buf, this.header);
        ByteBufUtil.writeVInt(buf, requestBytes.length);
        channel.write(buf);
        channel.writeAndFlush(Unpooled.wrappedBuffer(requestBytes));
    }

    private List<QueryRequest.NamedParameter> getNamedParameters() {
        Map<String, Object> namedParameters = this.remoteQuery.getParameters();
        if (namedParameters == null || namedParameters.isEmpty()) {
            return null;
        }
        SerializationContext serCtx = this.remoteQuery.getSerializationContext();
        ArrayList<QueryRequest.NamedParameter> params = new ArrayList<QueryRequest.NamedParameter>(namedParameters.size());
        for (Map.Entry<String, Object> e : namedParameters.entrySet()) {
            Object value = e.getValue();
            if (serCtx != null) {
                if (value instanceof Enum) {
                    EnumMarshaller encoder = (EnumMarshaller)serCtx.getMarshaller(value.getClass());
                    value = encoder.encode((Enum)value);
                } else if (value instanceof Boolean) {
                    value = value.toString();
                } else if (value instanceof Date) {
                    value = ((Date)value).getTime();
                } else if (value instanceof Instant) {
                    value = ((Instant)value).toEpochMilli();
                }
            }
            params.add(new QueryRequest.NamedParameter(e.getKey(), value));
        }
        return params;
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        byte[] responseBytes = ByteBufUtil.readArray(buf);
        this.complete(this.querySerializer.readQueryResponse(this.channelFactory.getMarshaller(), this.remoteQuery, responseBytes));
    }
}

