/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.marshall;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.marshall.BufferSizePredictor;
import org.infinispan.commons.marshall.CheckedInputStream;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.protostream.SerializationContext;

public final class MarshallerUtil {
    private static final Log log = LogFactory.getLog(MarshallerUtil.class, Log.class);

    private MarshallerUtil() {
    }

    public static SerializationContext getSerializationContext(RemoteCacheContainer remoteCacheManager) {
        Marshaller marshaller = remoteCacheManager.getMarshaller();
        if (marshaller instanceof ProtoStreamMarshaller) {
            return ((ProtoStreamMarshaller)marshaller).getSerializationContext();
        }
        if (marshaller == null) {
            throw new HotRodClientException("The cache manager must be configured with a ProtoStreamMarshaller and must be started before attempting to retrieve the ProtoStream SerializationContext");
        }
        throw new HotRodClientException("The cache manager is not configured with a ProtoStreamMarshaller");
    }

    public static <T> T bytes2obj(Marshaller marshaller, byte[] bytes, boolean objectStorage, ClassAllowList allowList) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            T ois;
            Object ret = marshaller.objectFromByteBuffer(bytes);
            if (objectStorage && ret instanceof byte[] && MarshallerUtil.isJavaSerialized((byte[])ret) && (ois = MarshallerUtil.tryJavaDeserialize(bytes, (byte[])ret, allowList)) != null) {
                return ois;
            }
            return (T)ret;
        }
        catch (Exception e) {
            throw Log.HOTROD.unableToUnmarshallBytes(Util.toHexString(bytes), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T tryJavaDeserialize(byte[] bytes, byte[] ret, ClassAllowList allowList) {
        try (CheckedInputStream ois = new CheckedInputStream(new ByteArrayInputStream(ret), allowList);){
            Object object = ois.readObject();
            return (T)object;
        }
        catch (CacheException ce) {
            throw ce;
        }
        catch (Exception ee) {
            if (!log.isDebugEnabled()) return null;
            log.debugf("Standard deserialization not in use for %s", (Object)Util.printArray(bytes));
            return null;
        }
    }

    private static boolean isJavaSerialized(byte[] bytes) {
        if (bytes.length > 2) {
            short magic = (short)((bytes[1] & 0xFF) + (bytes[0] << 8));
            return magic == -21267;
        }
        return false;
    }

    @Deprecated(forRemoval=true, since="12.0")
    public static byte[] obj2bytes(Marshaller marshaller, Object o, boolean isKey, int estimateKeySize, int estimateValueSize) {
        try {
            return marshaller.objectToByteBuffer(o, isKey ? estimateKeySize : estimateValueSize);
        }
        catch (IOException ioe) {
            throw new HotRodClientException("Unable to marshall object of type [" + o.getClass().getName() + "]", ioe);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public static byte[] obj2bytes(Marshaller marshaller, Object o, BufferSizePredictor sizePredictor) {
        try {
            byte[] bytes = marshaller.objectToByteBuffer(o, sizePredictor.nextSize(o));
            sizePredictor.recordSize(bytes.length);
            return bytes;
        }
        catch (IOException ioe) {
            throw new HotRodClientException("Unable to marshall object of type [" + o.getClass().getName() + "]", ioe);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return null;
        }
    }
}

