/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.tx;

import jakarta.transaction.Synchronization;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.transaction.xa.XAResource;
import org.infinispan.commons.tx.AsyncSynchronization;
import org.infinispan.commons.tx.AsyncXaResource;
import org.infinispan.commons.tx.TransactionResourceConverter;
import org.infinispan.commons.tx.XidImpl;

public enum DefaultResourceConverter implements TransactionResourceConverter
{
    INSTANCE;


    @Override
    public AsyncSynchronization convertSynchronization(Synchronization synchronization) {
        return synchronization instanceof AsyncSynchronization ? (AsyncSynchronization)((Object)synchronization) : new Sync(synchronization);
    }

    @Override
    public AsyncXaResource convertXaResource(XAResource resource) {
        return resource instanceof AsyncXaResource ? (AsyncXaResource)((Object)resource) : new Xa(resource);
    }

    private static class Sync
    implements AsyncSynchronization {
        private final Synchronization synchronization;

        private Sync(Synchronization synchronization) {
            this.synchronization = synchronization;
        }

        @Override
        public CompletionStage<Void> asyncBeforeCompletion() {
            CompletableFuture<Void> cf = new CompletableFuture<Void>();
            try {
                this.synchronization.beforeCompletion();
                cf.complete(null);
            }
            catch (Throwable t) {
                cf.completeExceptionally(t);
            }
            return cf;
        }

        @Override
        public CompletionStage<Void> asyncAfterCompletion(int status) {
            CompletableFuture<Void> cf = new CompletableFuture<Void>();
            try {
                this.synchronization.afterCompletion(status);
                cf.complete(null);
            }
            catch (Throwable t) {
                cf.completeExceptionally(t);
            }
            return cf;
        }
    }

    private static class Xa
    implements AsyncXaResource {
        private final XAResource resource;

        private Xa(XAResource resource) {
            this.resource = resource;
        }

        @Override
        public CompletionStage<Void> asyncEnd(XidImpl xid, int flags) {
            CompletableFuture<Void> cf = new CompletableFuture<Void>();
            try {
                this.resource.end(xid, flags);
                cf.complete(null);
            }
            catch (Throwable t) {
                cf.completeExceptionally(t);
            }
            return cf;
        }

        @Override
        public CompletionStage<Integer> asyncPrepare(XidImpl xid) {
            CompletableFuture<Integer> cf = new CompletableFuture<Integer>();
            try {
                cf.complete(this.resource.prepare(xid));
            }
            catch (Throwable t) {
                cf.completeExceptionally(t);
            }
            return cf;
        }

        @Override
        public CompletionStage<Void> asyncCommit(XidImpl xid, boolean onePhase) {
            CompletableFuture<Void> cf = new CompletableFuture<Void>();
            try {
                this.resource.commit(xid, onePhase);
                cf.complete(null);
            }
            catch (Throwable t) {
                cf.completeExceptionally(t);
            }
            return cf;
        }

        @Override
        public CompletionStage<Void> asyncRollback(XidImpl xid) {
            CompletableFuture<Void> cf = new CompletableFuture<Void>();
            try {
                this.resource.rollback(xid);
                cf.complete(null);
            }
            catch (Throwable t) {
                cf.completeExceptionally(t);
            }
            return cf;
        }
    }
}

