/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import java.util.Set;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslServerFactory;
import org.infinispan.commons.logging.Log;

public final class SaslUtils {
    public static Collection<SaslServerFactory> getSaslServerFactories(ClassLoader classLoader, Provider[] providers, boolean includeGlobal) {
        return SaslUtils.getFactories(SaslServerFactory.class, classLoader, providers, includeGlobal);
    }

    public static Collection<SaslClientFactory> getSaslClientFactories(ClassLoader classLoader, Provider[] providers, boolean includeGlobal) {
        return SaslUtils.getFactories(SaslClientFactory.class, classLoader, providers, includeGlobal);
    }

    private static <T> Collection<T> getFactories(Class<T> type, ClassLoader classLoader, Provider[] providers, boolean includeGlobal) {
        LinkedHashSet<T> factories = new LinkedHashSet<T>();
        if (providers != null) {
            SaslUtils.findFactories(type, factories, providers);
        }
        ServiceLoader<T> loader = ServiceLoader.load(type, classLoader);
        for (T factory : loader) {
            factories.add(factory);
        }
        if (includeGlobal) {
            SaslUtils.findFactories(type, factories, Security.getProviders());
        }
        return factories;
    }

    private static <T> void findFactories(Class<T> type, Set<T> factories, Provider[] providers) {
        for (Provider currentProvider : providers) {
            for (Provider.Service service : currentProvider.getServices()) {
                if (!type.getSimpleName().equals(service.getType())) continue;
                try {
                    factories.add(service.newInstance(null));
                }
                catch (NoSuchAlgorithmException e) {
                    Log.SECURITY.debugf((Throwable)e, "Could not add service '%s'", (Object)service);
                }
            }
        }
    }
}

