/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.client.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.query.remote.client.impl.Externalizers;

@ProtoTypeId(value=4400)
@SerializeWith(value=Externalizers.QueryRequestExternalizer.class)
public final class QueryRequest
implements JsonSerialization {
    public static final String QUERY_STRING_FIELD = "queryString";
    public static final String START_OFFSET_FIELD = "startOffset";
    public static final String MAX_RESULTS_FIELD = "maxResults";
    public static final String HIT_COUNT_ACCURACY = "hitCountAccuracy";
    public static final String NAMED_PARAMETERS_FIELD = "namedParameters";
    public static final String LOCAL_FIELD = "local";
    private String queryString;
    private List<NamedParameter> namedParameters;
    private Long startOffset;
    private Integer maxResults;
    private Integer hitCountAccuracy;
    private boolean local;

    @ProtoFactory
    QueryRequest(String queryString, Long startOffset, Integer maxResults, List<NamedParameter> namedParameters, boolean local, Integer hitCountAccuracy) {
        this.queryString = queryString;
        this.startOffset = startOffset;
        this.maxResults = maxResults;
        this.namedParameters = namedParameters;
        this.local = local;
        this.hitCountAccuracy = hitCountAccuracy;
    }

    public QueryRequest() {
    }

    @ProtoField(value=1)
    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    @ProtoField(value=3)
    public Long getStartOffset() {
        return this.startOffset == null ? Long.valueOf(-1L) : this.startOffset;
    }

    public void setStartOffset(Long startOffset) {
        this.startOffset = startOffset;
    }

    @ProtoField(value=4)
    public Integer getMaxResults() {
        return this.maxResults == null ? Integer.valueOf(-1) : this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    @ProtoField(value=5, collectionImplementation=ArrayList.class)
    public List<NamedParameter> getNamedParameters() {
        return this.namedParameters;
    }

    @ProtoField(value=6, defaultValue="false")
    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    @ProtoField(value=7)
    public Integer hitCountAccuracy() {
        return this.hitCountAccuracy == null ? Integer.valueOf(-1) : this.hitCountAccuracy;
    }

    public void hitCountAccuracy(Integer hitCountAccuracy) {
        this.hitCountAccuracy = hitCountAccuracy;
    }

    public void setNamedParameters(List<NamedParameter> namedParameters) {
        this.namedParameters = namedParameters;
    }

    public Map<String, Object> getNamedParametersMap() {
        if (this.namedParameters == null || this.namedParameters.isEmpty()) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(this.namedParameters.size());
        for (NamedParameter p : this.namedParameters) {
            params.put(p.getName(), p.getValue());
        }
        return params;
    }

    public static QueryRequest fromJson(Json jsonRequest) {
        String queryString = jsonRequest.at(QUERY_STRING_FIELD).asString();
        Json offsetValue = jsonRequest.at(START_OFFSET_FIELD);
        Json maxResults = jsonRequest.at(MAX_RESULTS_FIELD);
        Json hitCountAccuracy = jsonRequest.at(HIT_COUNT_ACCURACY);
        Json named = jsonRequest.at(NAMED_PARAMETERS_FIELD);
        List<NamedParameter> params = named.isArray() ? named.asJsonList().stream().map(NamedParameter::fromJson).collect(Collectors.toList()) : Collections.emptyList();
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.setQueryString(queryString);
        if (!offsetValue.isNull()) {
            queryRequest.setStartOffset(offsetValue.asLong());
        }
        if (!maxResults.isNull()) {
            queryRequest.setMaxResults(maxResults.asInteger());
        }
        if (!hitCountAccuracy.isNull()) {
            queryRequest.hitCountAccuracy(hitCountAccuracy.asInteger());
        }
        if (!params.isEmpty()) {
            queryRequest.setNamedParameters(params);
        }
        return queryRequest;
    }

    @Override
    public Json toJson() {
        return Json.object().set(QUERY_STRING_FIELD, (Object)this.queryString).set(START_OFFSET_FIELD, (Object)this.startOffset).set(MAX_RESULTS_FIELD, (Object)this.maxResults).set(HIT_COUNT_ACCURACY, (Object)this.hitCountAccuracy).set(NAMED_PARAMETERS_FIELD, Json.make(this.getNamedParameters())).set(LOCAL_FIELD, Json.factory().bool(this.local));
    }

    @SerializeWith(value=Externalizers.NamedParameterExternalizer.class)
    public static final class NamedParameter
    implements JsonSerialization {
        public static final String NAME_FIELD = "name";
        public static final String VALUE_FIELD = "value";
        private final String name;
        private final Object value;

        public NamedParameter(String name, Object value) {
            if (name == null) {
                throw new IllegalArgumentException("name cannot be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null");
            }
            this.name = name;
            this.value = value;
        }

        @ProtoFactory
        NamedParameter(String name, WrappedMessage wrappedValue) {
            this(name, wrappedValue.getValue());
        }

        @ProtoField(value=1)
        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        @ProtoField(number=2, name="value")
        WrappedMessage getWrappedValue() {
            return new WrappedMessage(this.value);
        }

        @Override
        public Json toJson() {
            return Json.object(NAME_FIELD, this.name).set(VALUE_FIELD, this.value);
        }

        public static NamedParameter fromJson(Json source) {
            String name = source.at(NAME_FIELD).asString();
            Object value = source.at(VALUE_FIELD).getValue();
            return new NamedParameter(name, value);
        }
    }
}

