/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.completable;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.operators.QueueSubscription;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;

public final class CompletableConcat
extends Completable {
    final Publisher<? extends CompletableSource> sources;
    final int prefetch;

    public CompletableConcat(Publisher<? extends CompletableSource> sources, int prefetch) {
        this.sources = sources;
        this.prefetch = prefetch;
    }

    @Override
    public void subscribeActual(CompletableObserver observer) {
        this.sources.subscribe(new CompletableConcatSubscriber(observer, this.prefetch));
    }

    static final class CompletableConcatSubscriber
    extends AtomicInteger
    implements FlowableSubscriber<CompletableSource>,
    Disposable {
        private static final long serialVersionUID = 9032184911934499404L;
        final CompletableObserver downstream;
        final int prefetch;
        final int limit;
        final ConcatInnerObserver inner;
        final AtomicBoolean once;
        int sourceFused;
        int consumed;
        SimpleQueue<CompletableSource> queue;
        Subscription upstream;
        volatile boolean done;
        volatile boolean active;

        CompletableConcatSubscriber(CompletableObserver actual, int prefetch) {
            this.downstream = actual;
            this.prefetch = prefetch;
            this.inner = new ConcatInnerObserver(this);
            this.once = new AtomicBoolean();
            this.limit = prefetch - (prefetch >> 2);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                long r;
                this.upstream = s;
                long l = r = this.prefetch == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)this.prefetch;
                if (s instanceof QueueSubscription) {
                    QueueSubscription qs = (QueueSubscription)s;
                    int m = qs.requestFusion(3);
                    if (m == 1) {
                        this.sourceFused = m;
                        this.queue = qs;
                        this.done = true;
                        this.downstream.onSubscribe(this);
                        this.drain();
                        return;
                    }
                    if (m == 2) {
                        this.sourceFused = m;
                        this.queue = qs;
                        this.downstream.onSubscribe(this);
                        s.request(r);
                        return;
                    }
                }
                this.queue = this.prefetch == Integer.MAX_VALUE ? new SpscLinkedArrayQueue<CompletableSource>(Flowable.bufferSize()) : new SpscArrayQueue<CompletableSource>(this.prefetch);
                this.downstream.onSubscribe(this);
                s.request(r);
            }
        }

        @Override
        public void onNext(CompletableSource t) {
            if (this.sourceFused == 0 && !this.queue.offer(t)) {
                this.onError(new QueueOverflowException());
                return;
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t) {
            if (this.once.compareAndSet(false, true)) {
                DisposableHelper.dispose(this.inner);
                this.downstream.onError(t);
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void dispose() {
            this.upstream.cancel();
            DisposableHelper.dispose(this.inner);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.inner.get());
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            do {
                boolean empty;
                CompletableSource cs;
                if (this.isDisposed()) {
                    return;
                }
                if (this.active) continue;
                boolean d = this.done;
                try {
                    cs = this.queue.poll();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.innerError(ex);
                    return;
                }
                boolean bl = empty = cs == null;
                if (d && empty) {
                    this.downstream.onComplete();
                    return;
                }
                if (empty) continue;
                this.active = true;
                cs.subscribe(this.inner);
                this.request();
            } while (this.decrementAndGet() != 0);
        }

        void request() {
            if (this.sourceFused != 1) {
                int p = this.consumed + 1;
                if (p == this.limit) {
                    this.consumed = 0;
                    this.upstream.request(p);
                } else {
                    this.consumed = p;
                }
            }
        }

        void innerError(Throwable e) {
            if (this.once.compareAndSet(false, true)) {
                this.upstream.cancel();
                this.downstream.onError(e);
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        void innerComplete() {
            this.active = false;
            this.drain();
        }

        static final class ConcatInnerObserver
        extends AtomicReference<Disposable>
        implements CompletableObserver {
            private static final long serialVersionUID = -5454794857847146511L;
            final CompletableConcatSubscriber parent;

            ConcatInnerObserver(CompletableConcatSubscriber parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.replace(this, d);
            }

            @Override
            public void onError(Throwable e) {
                this.parent.innerError(e);
            }

            @Override
            public void onComplete() {
                this.parent.innerComplete();
            }
        }
    }
}

