/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.cluster;

import java.util.concurrent.TimeUnit;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.infinispan.InfinispanConfiguration;

public abstract class InfinispanClusterConfiguration<C extends InfinispanConfiguration>
implements Cloneable {
    private final C configuration;
    private long lifespan;
    private TimeUnit lifespanTimeUnit;

    protected InfinispanClusterConfiguration(C configuration) {
        this.configuration = configuration;
        this.lifespan = 30L;
        this.lifespanTimeUnit = TimeUnit.SECONDS;
    }

    public long getLifespan() {
        return this.lifespan;
    }

    public void setLifespan(long lifespan) {
        this.lifespan = lifespan;
    }

    public TimeUnit getLifespanTimeUnit() {
        return this.lifespanTimeUnit;
    }

    public void setLifespanTimeUnit(TimeUnit lifespanTimeUnit) {
        this.lifespanTimeUnit = lifespanTimeUnit;
    }

    public void setConfigurationUri(String configurationUri) {
        ((InfinispanConfiguration)this.configuration).setConfigurationUri(configurationUri);
    }

    public C getConfiguration() {
        return this.configuration;
    }

    public InfinispanClusterConfiguration clone() {
        try {
            return (InfinispanClusterConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException(e);
        }
    }
}

