/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.remote;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.infinispan.InfinispanConfiguration;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteCustomListener;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;

@UriParams
public class InfinispanRemoteConfiguration
extends InfinispanConfiguration
implements Cloneable {
    @UriParam
    private String hosts;
    @UriParam(label="common,security", defaultValue="false")
    private boolean secure;
    @UriParam(label="common,security")
    private String username;
    @UriParam(label="common,security", secret=true)
    private String password;
    @UriParam(label="common,security")
    private String saslMechanism;
    @UriParam(label="common,security")
    private String securityRealm;
    @UriParam(label="common,security")
    private String securityServerName;
    @Metadata(autowired=true)
    @UriParam(label="advanced")
    private Configuration cacheContainerConfiguration;
    @Metadata(autowired=true)
    @UriParam(label="advanced")
    private RemoteCacheManager cacheContainer;
    @UriParam(label="advanced")
    private Map<String, String> configurationProperties;
    @UriParam(label="consumer")
    private String eventTypes;
    @UriParam(label="consumer")
    private InfinispanRemoteCustomListener customListener;
    @UriParam(label="advanced", javaType="java.lang.String")
    private Flag[] flags;

    public Configuration getCacheContainerConfiguration() {
        return this.cacheContainerConfiguration;
    }

    public void setCacheContainerConfiguration(Configuration cacheContainerConfiguration) {
        this.cacheContainerConfiguration = cacheContainerConfiguration;
    }

    public RemoteCacheManager getCacheContainer() {
        return this.cacheContainer;
    }

    public void setCacheContainer(RemoteCacheManager cacheContainer) {
        this.cacheContainer = cacheContainer;
    }

    public String getHosts() {
        return this.hosts;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSaslMechanism() {
        return this.saslMechanism;
    }

    public void setSaslMechanism(String saslMechanism) {
        this.saslMechanism = saslMechanism;
    }

    public String getSecurityRealm() {
        return this.securityRealm;
    }

    public void setSecurityRealm(String securityRealm) {
        this.securityRealm = securityRealm;
    }

    public String getSecurityServerName() {
        return this.securityServerName;
    }

    public void setSecurityServerName(String securityServerName) {
        this.securityServerName = securityServerName;
    }

    public Map<String, String> getConfigurationProperties() {
        return this.configurationProperties;
    }

    public void setConfigurationProperties(Map<String, String> configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public void addConfigurationProperty(String key, String value) {
        if (this.configurationProperties == null) {
            this.configurationProperties = new HashMap<String, String>();
        }
        this.configurationProperties.put(key, value);
    }

    public String getEventTypes() {
        return this.eventTypes;
    }

    public void setEventTypes(String eventTypes) {
        this.eventTypes = eventTypes;
    }

    public InfinispanRemoteCustomListener getCustomListener() {
        return this.customListener;
    }

    public void setCustomListener(InfinispanRemoteCustomListener customListener) {
        this.customListener = customListener;
    }

    public boolean hasCustomListener() {
        return this.customListener != null;
    }

    public Flag[] getFlags() {
        return this.flags;
    }

    public void setFlags(String flagsAsString) {
        String[] flagsArray = flagsAsString.split(",");
        this.flags = new Flag[flagsArray.length];
        for (int i = 0; i < flagsArray.length; ++i) {
            this.flags[i] = Flag.valueOf(flagsArray[i]);
        }
    }

    public void setFlags(Flag ... flags) {
        this.flags = flags;
    }

    public boolean hasFlags() {
        return this.flags != null && this.flags.length > 0;
    }

    public InfinispanRemoteConfiguration clone() {
        try {
            return (InfinispanRemoteConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException(e);
        }
    }
}

