/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.remote;

import org.apache.camel.Message;
import org.apache.camel.component.infinispan.InfinispanEndpoint;
import org.apache.camel.component.infinispan.InfinispanProducer;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteConfiguration;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteManager;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteUtil;
import org.apache.camel.spi.InvokeOnHeader;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.ServerStatistics;
import org.infinispan.query.dsl.Query;

public class InfinispanRemoteProducer
extends InfinispanProducer<InfinispanRemoteManager, InfinispanRemoteConfiguration> {
    public InfinispanRemoteProducer(InfinispanEndpoint endpoint, String cacheName, InfinispanRemoteManager manager, InfinispanRemoteConfiguration configuration) {
        super(endpoint, cacheName, manager, configuration);
    }

    @InvokeOnHeader(value="STATS")
    public void onStats(Message message) {
        RemoteCache cache = ((InfinispanRemoteManager)this.getManager()).getCache(message, this.getCacheName(), RemoteCache.class);
        ServerStatistics result = cache.serverStatistics();
        this.setResult(message, result);
    }

    @InvokeOnHeader(value="QUERY")
    public void onQuery(Message message) {
        RemoteCache cache = ((InfinispanRemoteManager)this.getManager()).getCache(message, this.getCacheName(), RemoteCache.class);
        Query<?> query = InfinispanRemoteUtil.buildQuery(this.getConfiguration(), cache, message);
        if (query != null) {
            this.setResult(message, query.execute().list());
        }
    }
}

