/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.influxdb.Cancellable;
import com.influxdb.client.InfluxQLQueryApi;
import com.influxdb.client.domain.InfluxQLQuery;
import com.influxdb.client.service.InfluxQLQueryService;
import com.influxdb.internal.AbstractQueryApi;
import com.influxdb.query.InfluxQLQueryResult;
import com.influxdb.utils.Arguments;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import retrofit2.Call;

public class InfluxQLQueryApiImpl
extends AbstractQueryApi
implements InfluxQLQueryApi {
    private final InfluxQLQueryService service;

    public InfluxQLQueryApiImpl(@Nonnull InfluxQLQueryService service) {
        Arguments.checkNotNull(service, "service");
        this.service = service;
    }

    @Override
    @Nonnull
    public InfluxQLQueryResult query(@Nonnull InfluxQLQuery influxQLQuery) {
        return this.query(influxQLQuery, influxQLQuery.getAcceptHeader(), null);
    }

    @Override
    @Nonnull
    public InfluxQLQueryResult query(@Nonnull InfluxQLQuery influxQLQuery, @Nullable InfluxQLQueryResult.Series.ValueExtractor valueExtractor) {
        return this.query(influxQLQuery, influxQLQuery.getAcceptHeader(), valueExtractor);
    }

    @Override
    @Nonnull
    public InfluxQLQueryResult queryCSV(@Nonnull InfluxQLQuery influxQLQuery) {
        return this.query(influxQLQuery, InfluxQLQuery.AcceptHeader.CSV, null);
    }

    @Override
    public InfluxQLQueryResult queryCSV(@Nonnull InfluxQLQuery influxQLQuery, @Nullable InfluxQLQueryResult.Series.ValueExtractor valueExtractor) {
        return this.query(influxQLQuery, InfluxQLQuery.AcceptHeader.CSV, valueExtractor);
    }

    @Override
    @Nonnull
    public InfluxQLQueryResult queryJSON(@Nonnull InfluxQLQuery influxQLQuery) {
        return this.query(influxQLQuery, InfluxQLQuery.AcceptHeader.JSON, null);
    }

    @Override
    @Nonnull
    public InfluxQLQueryResult queryJSON(@Nonnull InfluxQLQuery influxQLQuery, @Nullable InfluxQLQueryResult.Series.ValueExtractor valueExtractor) {
        return this.query(influxQLQuery, InfluxQLQuery.AcceptHeader.JSON, valueExtractor);
    }

    @Nonnull
    private InfluxQLQueryResult query(@Nonnull InfluxQLQuery influxQlQuery, @Nullable InfluxQLQuery.AcceptHeader accept, @Nullable InfluxQLQueryResult.Series.ValueExtractor valueExtractor) {
        Call<ResponseBody> call = this.service.query(influxQlQuery.getCommand(), influxQlQuery.getDatabase(), influxQlQuery.getRetentionPolicy(), influxQlQuery.getPrecision() != null ? influxQlQuery.getPrecision().getSymbol() : null, null, accept != null ? accept.getVal() : InfluxQLQuery.AcceptHeader.JSON.getVal());
        AtomicReference atomicReference = new AtomicReference();
        BiConsumer<Cancellable, BufferedSource> consumer = (cancellable, bufferedSource) -> {
            try {
                InfluxQLQueryResult result = this.parseResponse((BufferedSource)bufferedSource, (Cancellable)cancellable, accept, valueExtractor);
                atomicReference.set(result);
            }
            catch (IOException e) {
                ERROR_CONSUMER.accept(e);
            }
        };
        this.query(call, consumer, (Consumer<? super Throwable>)ERROR_CONSUMER, EMPTY_ACTION, (Boolean)false);
        return (InfluxQLQueryResult)atomicReference.get();
    }

    private InfluxQLQueryResult parseResponse(@Nonnull BufferedSource bufferedSource, @Nonnull Cancellable cancellable, @Nonnull InfluxQLQuery.AcceptHeader accept, @Nullable InfluxQLQueryResult.Series.ValueExtractor valueExtractor) throws IOException {
        Arguments.checkNotNull(bufferedSource, "bufferedSource");
        try (InputStreamReader reader = new InputStreamReader(bufferedSource.inputStream(), StandardCharsets.UTF_8);){
            if (accept == InfluxQLQuery.AcceptHeader.CSV) {
                InfluxQLQueryResult influxQLQueryResult = InfluxQLQueryApiImpl.readInfluxQLCSVResult(reader, cancellable, valueExtractor);
                return influxQLQueryResult;
            }
            InfluxQLQueryResult influxQLQueryResult = InfluxQLQueryApiImpl.readInfluxQLJsonResult(reader, cancellable, valueExtractor);
            return influxQLQueryResult;
        }
    }

    static InfluxQLQueryResult readInfluxQLCSVResult(@Nonnull Reader reader, @Nonnull Cancellable cancellable, @Nullable InfluxQLQueryResult.Series.ValueExtractor valueExtractor) throws IOException {
        ArrayList<InfluxQLQueryResult.Result> results = new ArrayList<InfluxQLQueryResult.Result>();
        LinkedHashMap<List, InfluxQLQueryResult.Series> series = null;
        LinkedHashMap<String, Integer> headerCols = null;
        boolean nameCol = false;
        boolean tagsCol = true;
        int dynamicColumnsStartIndex = 2;
        try (CSVParser parser = new CSVParser(reader, CSVFormat.DEFAULT.builder().setIgnoreEmptyLines(false).build());){
            for (CSVRecord csvRecord : parser) {
                if (cancellable.isCancelled()) {
                    break;
                }
                int resultIndex = results.size();
                if (csvRecord.size() == 1 && csvRecord.get(0).equals("")) {
                    if (series != null) {
                        InfluxQLQueryResult.Result result = new InfluxQLQueryResult.Result(resultIndex, new ArrayList<InfluxQLQueryResult.Series>(series.values()));
                        results.add(result);
                    }
                    series = null;
                    continue;
                }
                if (series == null) {
                    List<String> header = csvRecord.toList();
                    headerCols = new LinkedHashMap<String, Integer>();
                    for (int col = 2; col < header.size(); ++col) {
                        String colName = header.get(col);
                        headerCols.put(colName, col - 2);
                    }
                    series = new LinkedHashMap<List, InfluxQLQueryResult.Series>();
                    continue;
                }
                String name = csvRecord.get(0);
                Map<String, String> finalTags = InfluxQLQueryApiImpl.parseTags(csvRecord.get(1));
                LinkedHashMap<String, Integer> finalHeaderCols = headerCols;
                InfluxQLQueryResult.Series serie = series.computeIfAbsent(Arrays.asList(name, finalTags), n -> new InfluxQLQueryResult.Series(name, finalTags, finalHeaderCols));
                Object[] values2 = headerCols.entrySet().stream().map(entry -> {
                    String value = csvRecord.get((Integer)entry.getValue() + 2);
                    if (valueExtractor != null) {
                        return valueExtractor.extractValue((String)entry.getKey(), value, resultIndex, serie.getName());
                    }
                    return value;
                }).toArray();
                InfluxQLQueryResult.Series series2 = serie;
                Objects.requireNonNull(series2);
                InfluxQLQueryResult.Series.Record record = new InfluxQLQueryResult.Series.Record(series2, values2);
                serie.addRecord(record);
            }
        }
        if (series != null) {
            InfluxQLQueryResult.Result result = new InfluxQLQueryResult.Result(results.size(), new ArrayList<InfluxQLQueryResult.Series>(series.values()));
            results.add(result);
        }
        return new InfluxQLQueryResult(results);
    }

    private static Map<String, String> parseTags(@Nonnull String value) {
        HashMap<String, String> tags = new HashMap<String, String>();
        if (value.length() > 0) {
            for (String entry : value.split(",")) {
                String[] kv = entry.split("=");
                tags.put(kv[0], kv[1]);
            }
        }
        return tags;
    }

    static InfluxQLQueryResult readInfluxQLJsonResult(@Nonnull Reader reader, @Nonnull Cancellable cancellable, @Nullable InfluxQLQueryResult.Series.ValueExtractor valueExtractor) {
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)InfluxQLQueryResult.class), new ResultsDeserializer(cancellable)).registerTypeAdapter((Type)((Object)InfluxQLQueryResult.Result.class), new ResultDeserializer(valueExtractor)).create();
        try {
            return gson.fromJson(reader, InfluxQLQueryResult.class);
        }
        catch (JsonIOException | JsonSyntaxException jse) {
            ERROR_CONSUMER.accept(jse);
            return null;
        }
    }

    public static class ResultsDeserializer
    implements JsonDeserializer<InfluxQLQueryResult> {
        Cancellable cancellable;

        public ResultsDeserializer(Cancellable cancellable) {
            this.cancellable = cancellable;
        }

        @Override
        public InfluxQLQueryResult deserialize(JsonElement elem, Type type, JsonDeserializationContext ctx) throws JsonParseException {
            ArrayList<InfluxQLQueryResult.Result> results = new ArrayList<InfluxQLQueryResult.Result>();
            JsonObject result = elem.getAsJsonObject();
            if (result.has("results")) {
                JsonArray jsonArray = result.get("results").getAsJsonArray();
                for (JsonElement jsonElement : jsonArray) {
                    if (this.cancellable.isCancelled()) break;
                    results.add((InfluxQLQueryResult.Result)ctx.deserialize(jsonElement, (Type)((Object)InfluxQLQueryResult.Result.class)));
                }
            }
            return new InfluxQLQueryResult(results);
        }
    }

    public static class ResultDeserializer
    implements JsonDeserializer<InfluxQLQueryResult.Result> {
        InfluxQLQueryResult.Series.ValueExtractor extractor;

        public ResultDeserializer(InfluxQLQueryResult.Series.ValueExtractor extractor) {
            this.extractor = extractor;
        }

        @Override
        public InfluxQLQueryResult.Result deserialize(JsonElement elem, Type type, JsonDeserializationContext ctx) throws JsonParseException {
            JsonObject eobj = elem.getAsJsonObject();
            int id = eobj.get("statement_id").getAsInt();
            ArrayList<InfluxQLQueryResult.Series> series = new ArrayList<InfluxQLQueryResult.Series>();
            JsonArray seriesArray = eobj.getAsJsonArray("series");
            if (seriesArray != null) {
                for (JsonElement jserie : seriesArray) {
                    JsonObject sobj = jserie.getAsJsonObject();
                    String name = sobj.getAsJsonObject().get("name").getAsString();
                    LinkedHashMap<String, Integer> columns = new LinkedHashMap<String, Integer>();
                    LinkedHashMap<String, String> tags = null;
                    JsonArray jac = sobj.get("columns").getAsJsonArray();
                    AtomicInteger count = new AtomicInteger(0);
                    jac.forEach(e -> columns.put(e.getAsString(), count.getAndIncrement()));
                    InfluxQLQueryResult.Series serie = null;
                    if (sobj.get("tags") != null) {
                        JsonObject tagsObj = sobj.get("tags").getAsJsonObject();
                        tags = new LinkedHashMap<String, String>();
                        for (String key : tagsObj.keySet()) {
                            tags.put(key, tagsObj.get(key).getAsString());
                        }
                        serie = new InfluxQLQueryResult.Series(name, tags, columns);
                    } else {
                        serie = new InfluxQLQueryResult.Series(name, columns);
                    }
                    JsonArray jvals = sobj.get("values").getAsJsonArray();
                    if (jvals != null) {
                        for (JsonElement jval : jvals) {
                            ArrayList<Object> values2 = new ArrayList<Object>();
                            JsonArray jae = jval.getAsJsonArray();
                            int index = 0;
                            for (JsonElement je : jae) {
                                ArrayList<String> columnKeys = new ArrayList<String>(serie.getColumns().keySet());
                                if (this.extractor != null) {
                                    String stringVal = je.getAsString();
                                    Object ov = this.extractor.extractValue((String)columnKeys.get(index), stringVal, id, serie.getName());
                                    values2.add(ov);
                                } else {
                                    values2.add(je.getAsString());
                                }
                                ++index;
                            }
                            InfluxQLQueryResult.Series series2 = serie;
                            Objects.requireNonNull(series2);
                            serie.addRecord(new InfluxQLQueryResult.Series.Record(series2, values2.toArray()));
                        }
                    }
                    series.add(serie);
                }
            }
            return new InfluxQLQueryResult.Result(id, series);
        }
    }
}

