/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.client.InfluxDBClientOptions;
import com.influxdb.client.WriteApiBlocking;
import com.influxdb.client.domain.WritePrecision;
import com.influxdb.client.internal.AbstractWriteBlockingClient;
import com.influxdb.client.internal.AbstractWriteClient;
import com.influxdb.client.service.WriteService;
import com.influxdb.client.write.Point;
import com.influxdb.client.write.WriteParameters;
import com.influxdb.exceptions.InfluxException;
import com.influxdb.utils.Arguments;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class WriteApiBlockingImpl
extends AbstractWriteBlockingClient
implements WriteApiBlocking {
    WriteApiBlockingImpl(@Nonnull WriteService service, @Nonnull InfluxDBClientOptions options) {
        super(service, options);
    }

    @Override
    public void writeRecord(@Nonnull WritePrecision precision, @Nullable String record) {
        Arguments.checkNotNull(this.options.getBucket(), "InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.writeRecord(this.options.getBucket(), this.options.getOrg(), precision, record);
    }

    @Override
    public void writeRecord(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision, @Nullable String record) {
        this.writeRecord(record, new WriteParameters(bucket, org, precision));
    }

    @Override
    public void writeRecord(@Nullable String record, @Nonnull WriteParameters parameters) throws InfluxException {
        if (record == null) {
            return;
        }
        Arguments.checkNotNull(parameters, "WriteParameters");
        parameters.check(this.options);
        this.write(parameters, new AbstractWriteClient.BatchWriteDataRecord(record));
    }

    @Override
    public void writeRecords(@Nonnull WritePrecision precision, @Nonnull List<String> records) {
        Arguments.checkNotNull(this.options.getBucket(), "InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.writeRecords(this.options.getBucket(), this.options.getOrg(), precision, records);
    }

    @Override
    public void writeRecords(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision, @Nonnull List<String> records) {
        Arguments.checkNonEmpty(bucket, "bucket");
        Arguments.checkNonEmpty(org, "org");
        Arguments.checkNotNull((Object)precision, "WritePrecision is required");
        Arguments.checkNotNull(records, "records");
        this.writeRecords(records, new WriteParameters(bucket, org, precision));
    }

    @Override
    public void writeRecords(@Nonnull List<String> records, @Nonnull WriteParameters parameters) throws InfluxException {
        Arguments.checkNotNull(records, "records");
        Arguments.checkNotNull(parameters, "WriteParameters");
        parameters.check(this.options);
        this.write(parameters, records.stream().map(AbstractWriteClient.BatchWriteDataRecord::new));
    }

    @Override
    public void writePoint(@Nullable Point point) {
        Arguments.checkNotNull(this.options.getBucket(), "InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.writePoint(this.options.getBucket(), this.options.getOrg(), point);
    }

    @Override
    public void writePoint(@Nonnull String bucket, @Nonnull String org, @Nullable Point point) {
        Arguments.checkNonEmpty(bucket, "bucket");
        Arguments.checkNonEmpty(org, "org");
        this.writePoint(point, new WriteParameters(bucket, org, WriteParameters.DEFAULT_WRITE_PRECISION));
    }

    @Override
    public void writePoint(@Nullable Point point, @Nonnull WriteParameters parameters) throws InfluxException {
        if (point == null) {
            return;
        }
        Arguments.checkNotNull(parameters, "WriteParameters");
        parameters.check(this.options);
        this.writePoints(Collections.singletonList(point), parameters);
    }

    @Override
    public void writePoints(@Nonnull List<Point> points) {
        Arguments.checkNotNull(this.options.getBucket(), "InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.writePoints(this.options.getBucket(), this.options.getOrg(), points);
    }

    @Override
    public void writePoints(@Nonnull String bucket, @Nonnull String org, @Nonnull List<Point> points) {
        Arguments.checkNonEmpty(bucket, "bucket");
        Arguments.checkNonEmpty(org, "org");
        Arguments.checkNotNull(points, "points");
        this.writePoints(points, new WriteParameters(bucket, org, WriteParameters.DEFAULT_WRITE_PRECISION));
    }

    @Override
    public void writePoints(@Nonnull List<Point> points, @Nonnull WriteParameters parameters) throws InfluxException {
        Arguments.checkNotNull(points, "points");
        Arguments.checkNotNull(parameters, "WriteParameters");
        parameters.check(this.options);
        points.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(Point::getPrecision, LinkedHashMap::new, Collectors.toList())).forEach((precision, grouped) -> {
            WriteParameters groupParameters = parameters.copy((WritePrecision)((Object)precision), this.options);
            this.write(groupParameters, grouped.stream().map(it -> new AbstractWriteClient.BatchWriteDataPoint((Point)it, this.options)));
        });
    }

    @Override
    public <M> void writeMeasurement(@Nonnull WritePrecision precision, @Nullable M measurement) {
        Arguments.checkNotNull(this.options.getBucket(), "InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.writeMeasurement(this.options.getBucket(), this.options.getOrg(), precision, measurement);
    }

    @Override
    public <M> void writeMeasurement(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision, @Nullable M measurement) {
        this.writeMeasurement(measurement, new WriteParameters(bucket, org, precision));
    }

    @Override
    public <M> void writeMeasurement(@Nullable M measurement, @Nonnull WriteParameters parameters) throws InfluxException {
        if (measurement == null) {
            return;
        }
        Arguments.checkNotNull(parameters, "WriteParameters");
        parameters.check(this.options);
        this.writeMeasurements(Collections.singletonList(measurement), parameters);
    }

    @Override
    public <M> void writeMeasurements(@Nonnull WritePrecision precision, @Nonnull List<M> measurements) {
        Arguments.checkNotNull(this.options.getBucket(), "InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.writeMeasurements(this.options.getBucket(), this.options.getOrg(), precision, measurements);
    }

    @Override
    public <M> void writeMeasurements(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision, @Nonnull List<M> measurements) {
        Arguments.checkNonEmpty(bucket, "bucket");
        Arguments.checkNonEmpty(org, "org");
        Arguments.checkNotNull((Object)precision, "WritePrecision is required");
        Arguments.checkNotNull(measurements, "records");
        this.writeMeasurements(measurements, new WriteParameters(bucket, org, precision));
    }

    @Override
    public <M> void writeMeasurements(@Nonnull List<M> measurements, @Nonnull WriteParameters parameters) throws InfluxException {
        Arguments.checkNotNull(measurements, "points");
        Arguments.checkNotNull(parameters, "WriteParameters");
        parameters.check(this.options);
        this.write(parameters, measurements.stream().map(it -> this.toMeasurementBatch(it, parameters.precisionSafe(this.options))));
    }

    private void write(@Nonnull WriteParameters parameters, @Nonnull AbstractWriteClient.BatchWriteData data) {
        this.write(parameters, Stream.of(data));
    }
}

