/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.subscriptions;

import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

public class SubscriptionArbiter
extends AtomicInteger
implements Subscription {
    private static final long serialVersionUID = -2189523197179400958L;
    Subscription actual;
    long requested;
    final AtomicReference<Subscription> missedSubscription;
    final AtomicLong missedRequested;
    final AtomicLong missedProduced;
    final boolean cancelOnReplace;
    volatile boolean cancelled;
    protected boolean unbounded;

    public SubscriptionArbiter(boolean cancelOnReplace) {
        this.cancelOnReplace = cancelOnReplace;
        this.missedSubscription = new AtomicReference();
        this.missedRequested = new AtomicLong();
        this.missedProduced = new AtomicLong();
    }

    public final void setSubscription(Subscription s) {
        if (this.cancelled) {
            s.cancel();
            return;
        }
        Objects.requireNonNull(s, "s is null");
        if (this.get() == 0 && this.compareAndSet(0, 1)) {
            Subscription a = this.actual;
            if (a != null && this.cancelOnReplace) {
                a.cancel();
            }
            this.actual = s;
            long r = this.requested;
            if (this.decrementAndGet() != 0) {
                this.drainLoop();
            }
            if (r != 0L) {
                s.request(r);
            }
            return;
        }
        Subscription a = this.missedSubscription.getAndSet(s);
        if (a != null && this.cancelOnReplace) {
            a.cancel();
        }
        this.drain();
    }

    @Override
    public final void request(long n) {
        if (SubscriptionHelper.validate(n)) {
            if (this.unbounded) {
                return;
            }
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                long r = this.requested;
                if (r != Long.MAX_VALUE) {
                    this.requested = r = BackpressureHelper.addCap(r, n);
                    if (r == Long.MAX_VALUE) {
                        this.unbounded = true;
                    }
                }
                Subscription a = this.actual;
                if (this.decrementAndGet() != 0) {
                    this.drainLoop();
                }
                if (a != null) {
                    a.request(n);
                }
                return;
            }
            BackpressureHelper.add(this.missedRequested, n);
            this.drain();
        }
    }

    public final void produced(long n) {
        if (this.unbounded) {
            return;
        }
        if (this.get() == 0 && this.compareAndSet(0, 1)) {
            long r = this.requested;
            if (r != Long.MAX_VALUE) {
                long u = r - n;
                if (u < 0L) {
                    SubscriptionHelper.reportMoreProduced(u);
                    u = 0L;
                }
                this.requested = u;
            }
            if (this.decrementAndGet() == 0) {
                return;
            }
            this.drainLoop();
            return;
        }
        BackpressureHelper.add(this.missedProduced, n);
        this.drain();
    }

    @Override
    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.drain();
        }
    }

    final void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        this.drainLoop();
    }

    final void drainLoop() {
        int missed = 1;
        long requestAmount = 0L;
        Subscription requestTarget = null;
        do {
            long mp;
            long mr;
            Subscription ms;
            if ((ms = this.missedSubscription.get()) != null) {
                ms = this.missedSubscription.getAndSet(null);
            }
            if ((mr = this.missedRequested.get()) != 0L) {
                mr = this.missedRequested.getAndSet(0L);
            }
            if ((mp = this.missedProduced.get()) != 0L) {
                mp = this.missedProduced.getAndSet(0L);
            }
            Subscription a = this.actual;
            if (this.cancelled) {
                if (a != null) {
                    a.cancel();
                    this.actual = null;
                }
                if (ms == null) continue;
                ms.cancel();
                continue;
            }
            long r = this.requested;
            if (r != Long.MAX_VALUE) {
                long u = BackpressureHelper.addCap(r, mr);
                if (u != Long.MAX_VALUE) {
                    long v = u - mp;
                    if (v < 0L) {
                        SubscriptionHelper.reportMoreProduced(v);
                        v = 0L;
                    }
                    r = v;
                } else {
                    r = u;
                }
                this.requested = r;
            }
            if (ms != null) {
                if (a != null && this.cancelOnReplace) {
                    a.cancel();
                }
                this.actual = ms;
                if (r == 0L) continue;
                requestAmount = BackpressureHelper.addCap(requestAmount, r);
                requestTarget = ms;
                continue;
            }
            if (a == null || mr == 0L) continue;
            requestAmount = BackpressureHelper.addCap(requestAmount, mr);
            requestTarget = a;
        } while ((missed = this.addAndGet(-missed)) != 0);
        if (requestAmount != 0L) {
            requestTarget.request(requestAmount);
        }
    }

    public final boolean isUnbounded() {
        return this.unbounded;
    }

    public final boolean isCancelled() {
        return this.cancelled;
    }
}

