/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.observables;

import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.SchedulerSupport;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.internal.functions.ObjectHelper;
import io.reactivex.rxjava3.internal.operators.observable.ObservableAutoConnect;
import io.reactivex.rxjava3.internal.operators.observable.ObservableRefCount;
import io.reactivex.rxjava3.internal.util.ConnectConsumer;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public abstract class ConnectableObservable<T>
extends Observable<T> {
    @SchedulerSupport(value="none")
    public abstract void connect(@NonNull Consumer<? super Disposable> var1);

    @SchedulerSupport(value="none")
    public abstract void reset();

    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable connect() {
        ConnectConsumer cc = new ConnectConsumer();
        this.connect(cc);
        return cc.disposable;
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public Observable<T> refCount() {
        return RxJavaPlugins.onAssembly(new ObservableRefCount(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> refCount(int observerCount) {
        return this.refCount(observerCount, 0L, TimeUnit.NANOSECONDS, Schedulers.trampoline());
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Observable<T> refCount(long timeout2, @NonNull TimeUnit unit) {
        return this.refCount(1, timeout2, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> refCount(long timeout2, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.refCount(1, timeout2, unit, scheduler);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Observable<T> refCount(int observerCount, long timeout2, @NonNull TimeUnit unit) {
        return this.refCount(observerCount, timeout2, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> refCount(int observerCount, long timeout2, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        ObjectHelper.verifyPositive(observerCount, "observerCount");
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableRefCount(this, observerCount, timeout2, unit, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public Observable<T> autoConnect() {
        return this.autoConnect(1);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public Observable<T> autoConnect(int numberOfObservers) {
        return this.autoConnect(numberOfObservers, Functions.emptyConsumer());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public Observable<T> autoConnect(int numberOfObservers, @NonNull Consumer<? super Disposable> connection) {
        Objects.requireNonNull(connection, "connection is null");
        if (numberOfObservers <= 0) {
            this.connect(connection);
            return RxJavaPlugins.onAssembly(this);
        }
        return RxJavaPlugins.onAssembly(new ObservableAutoConnect(this, numberOfObservers, connection));
    }
}

