/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.influxdb2.converters;

import com.influxdb.client.write.Point;
import java.util.Map;
import org.apache.camel.Converter;
import org.apache.camel.component.influxdb2.CamelInfluxDb2Exception;

@Converter(generateLoader=true)
public final class CamelInfluxDb2Converters {
    private CamelInfluxDb2Converters() {
    }

    @Converter
    public static Point fromMapToPoint(Map<String, Object> map) {
        Object measurementName = map.get("CamelInfluxDB2MeasurementName");
        if (measurementName == null) {
            String format = String.format("Unable to find the header for the measurement in: %s", map.keySet().toString());
            throw new CamelInfluxDb2Exception(format);
        }
        String measurenmentNameString = measurementName.toString();
        Point point = Point.measurement(measurenmentNameString);
        map.remove("CamelInfluxDB2MeasurementName");
        point.addFields(map);
        map.put("CamelInfluxDB2MeasurementName", measurementName);
        return point;
    }
}

