/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.concurrent;

import java.util.concurrent.ThreadFactory;
import org.apache.camel.util.concurrent.ThreadHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CamelThreadFactory
implements ThreadFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CamelThreadFactory.class);
    private final String pattern;
    private final String name;
    private final boolean daemon;

    public CamelThreadFactory(String pattern, String name, boolean daemon) {
        this.pattern = pattern;
        this.name = name;
        this.daemon = daemon;
    }

    @Override
    public Thread newThread(Runnable runnable2) {
        String threadName = ThreadHelper.resolveThreadName(this.pattern, this.name);
        Thread answer = new Thread(runnable2, threadName);
        answer.setDaemon(this.daemon);
        LOG.trace("Created thread[{}] -> {}", (Object)threadName, (Object)answer);
        return answer;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "CamelThreadFactory[" + this.name + "]";
    }
}

