/*
 * Decompiled with CFR 0.152.
 */
package io.iron.ironmq;

import com.google.gson.annotations.SerializedName;
import io.iron.ironmq.Alert;
import io.iron.ironmq.QueuePushModel;
import io.iron.ironmq.Subscriber;
import java.util.ArrayList;

public class QueueModel {
    private String id;
    private String name;
    private String type;
    private Long size;
    private String project_id;
    private Long total_messages;
    private QueuePushModel push;
    private ArrayList<Alert> alerts;
    @SerializedName(value="message_timeout")
    private Integer messageTimeout;
    @SerializedName(value="message_expiration")
    private Integer messageExpiration;

    public QueueModel(String id, String name, Integer size, Integer total_messages, String project_id, Integer retries, String pushType, Integer retriesDelay, String errorQueue, ArrayList<Subscriber> subscribers, ArrayList<Alert> alerts) {
        this.id = id;
        this.name = name;
        this.size = (long)size;
        this.total_messages = (long)total_messages;
        this.project_id = project_id;
        this.alerts = alerts;
    }

    public QueueModel(int messageExpiration, int retries, String pushType, int retries_delay, String error_queue, ArrayList<Subscriber> subscribers, ArrayList<Alert> alerts, int messageTimeout) {
        this.messageExpiration = messageExpiration;
        this.alerts = alerts;
        this.messageTimeout = messageTimeout;
    }

    public QueueModel(int messageTimeout, int messageExpiration) {
        this.messageTimeout = messageTimeout;
        this.messageExpiration = messageExpiration;
    }

    public QueueModel(ArrayList<Alert> alerts) {
        this.alerts = alerts;
    }

    public QueueModel(QueuePushModel push) {
        this.push = push;
    }

    public QueueModel() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Deprecated
    public int getSize() {
        return (int)this.size.longValue();
    }

    public long getSizeLong() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Deprecated
    public int getTotal_messages() {
        return (int)this.total_messages.longValue();
    }

    @Deprecated
    public int getTotalMessages() {
        return (int)this.total_messages.longValue();
    }

    public long getTotalMessagesLong() {
        return this.total_messages;
    }

    @Deprecated
    public void setTotal_messages(int total_messages) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String getProject_id() {
        return this.project_id;
    }

    public String getProjectId() {
        return this.project_id;
    }

    @Deprecated
    public void setProject_id(String project_id) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public int getRetries() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setRetries(int retries) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String getPushType() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setPushType(String pushType) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public int getRetriesDelay() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setRetriesDelay(int retriesDelay) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String getErrorQueue() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setErrorQueue(String errorQueue) {
        throw new UnsupportedOperationException();
    }

    public ArrayList<Subscriber> getSubscribers() {
        return this.getPushInfo().getSubscribers();
    }

    @Deprecated
    public void setSubscribers(ArrayList<Subscriber> subscribers) {
        throw new UnsupportedOperationException();
    }

    public ArrayList<Alert> getAlerts() {
        return this.alerts;
    }

    public void setAlerts(ArrayList<Alert> alerts) {
        this.alerts = alerts;
    }

    public int getMessageTimeout() {
        return this.messageTimeout;
    }

    public void setMessageTimeout(int messageTimeout) {
        this.messageTimeout = messageTimeout;
    }

    public int getMessageExpiration() {
        return this.messageExpiration;
    }

    public void setMessageExpiration(int messageExpiration) {
        this.messageExpiration = messageExpiration;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public QueuePushModel getPushInfo() {
        return this.push;
    }

    public void setPushInfo(QueuePushModel push) {
        this.push = push;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscriber(Subscriber subscriber) {
        QueueModel queueModel = this;
        synchronized (queueModel) {
            if (this.push == null) {
                this.push = new QueuePushModel();
            }
        }
        this.push.addSubscriber(subscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscribers(ArrayList<Subscriber> subscribers) {
        QueueModel queueModel = this;
        synchronized (queueModel) {
            if (this.push == null) {
                this.push = new QueuePushModel();
            }
        }
        this.push.addSubscribers(subscribers);
    }
}

