/*
 * Decompiled with CFR 0.152.
 */
package io.iron.ironmq;

import com.google.gson.Gson;
import io.iron.ironmq.Alert;
import io.iron.ironmq.Alerts;
import io.iron.ironmq.Client;
import io.iron.ironmq.EmptyQueueException;
import io.iron.ironmq.Ids;
import io.iron.ironmq.IronReader;
import io.iron.ironmq.Message;
import io.iron.ironmq.MessageContainer;
import io.iron.ironmq.MessageOptions;
import io.iron.ironmq.Messages;
import io.iron.ironmq.MessagesArrayList;
import io.iron.ironmq.MessagesOptions;
import io.iron.ironmq.MessagesReservationModel;
import io.iron.ironmq.QueueContainer;
import io.iron.ironmq.QueueModel;
import io.iron.ironmq.QueuePushModel;
import io.iron.ironmq.SubscribedMessageOptions;
import io.iron.ironmq.Subscriber;
import io.iron.ironmq.Subscribers;
import io.iron.ironmq.SubscribersInfo;
import java.io.IOException;
import java.util.ArrayList;

public class Queue {
    private final Client client;
    private final String name;
    private static final Gson gson = new Gson();

    public Queue(Client client, String name) {
        if (name == null) {
            throw new NullPointerException("Queue name cannot be null");
        }
        this.client = client;
        this.name = name;
    }

    @Deprecated
    public Message get() throws IOException {
        return this.reserve();
    }

    public Message reserve() throws IOException {
        Message msg;
        Messages msgs = this.reserve(1);
        try {
            msg = msgs.getMessage(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EmptyQueueException();
        }
        return msg;
    }

    @Deprecated
    public Messages get(int numberOfMessages) throws IOException {
        return this.reserve(numberOfMessages);
    }

    public Messages reserve(int numberOfMessages) throws IOException {
        return this.reserve(numberOfMessages, -1);
    }

    @Deprecated
    public Messages get(int numberOfMessages, int timeout) throws IOException {
        return this.reserve(numberOfMessages, timeout);
    }

    public Messages reserve(int numberOfMessages, int timeout) throws IOException {
        return this.reserve(numberOfMessages, timeout, 0);
    }

    public Messages reserve(int numberOfMessages, int timeout, int wait) throws IOException {
        if (numberOfMessages < 1 || numberOfMessages > 100) {
            throw new IllegalArgumentException("numberOfMessages has to be within 1..100");
        }
        MessagesReservationModel payload = new MessagesReservationModel(numberOfMessages, timeout, wait);
        String url = "queues/" + this.name + "/reservations";
        IronReader reader = this.client.post(url, gson.toJson(payload));
        Messages messages = gson.fromJson(reader.reader, Messages.class);
        reader.close();
        return messages;
    }

    public Message peek() throws IOException {
        Message msg;
        Messages msgs = this.peek(1);
        try {
            msg = msgs.getMessage(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EmptyQueueException();
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Messages peek(int numberOfMessages) throws IOException {
        if (numberOfMessages < 1 || numberOfMessages > 100) {
            throw new IllegalArgumentException("numberOfMessages has to be within 1..100");
        }
        IronReader reader = this.client.get("queues/" + this.name + "/messages?n=" + numberOfMessages);
        try {
            Messages messages = gson.fromJson(reader.reader, Messages.class);
            return messages;
        }
        finally {
            reader.close();
        }
    }

    public MessageOptions touchMessage(Message message) throws IOException {
        return this.touchMessage(message, null);
    }

    public MessageOptions touchMessage(Message message, int timeout) throws IOException {
        return this.touchMessage(message, Long.valueOf(timeout));
    }

    public MessageOptions touchMessage(Message message, Long timeout) throws IOException {
        MessageOptions messageOptions = this.touchMessage(message.getId(), message.getReservationId(), timeout);
        message.setReservationId(messageOptions.getReservationId());
        return messageOptions;
    }

    public MessageOptions touchMessage(String id, String reservationId) throws IOException {
        return this.touchMessage(id, reservationId, null);
    }

    public MessageOptions touchMessage(String id, String reservationId, int timeout) throws IOException {
        return this.touchMessage(id, reservationId, Long.valueOf(timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageOptions touchMessage(String id, String reservationId, Long timeout) throws IOException {
        String payload = gson.toJson(new MessageOptions(null, reservationId, timeout));
        IronReader reader = this.client.post("queues/" + this.name + "/messages/" + id + "/touch", payload);
        try {
            MessageOptions messageOptions = gson.fromJson(reader.reader, MessageOptions.class);
            return messageOptions;
        }
        finally {
            reader.close();
        }
    }

    public void deleteMessage(String id) throws IOException {
        this.deleteMessage(id, null);
    }

    public void deleteMessage(String id, String reservationId) throws IOException {
        this.deleteMessage(id, reservationId, null);
    }

    public void deleteMessage(String id, String reservationId, String subscriberName) throws IOException {
        String payload = gson.toJson(new SubscribedMessageOptions(reservationId, subscriberName));
        IronReader reader = this.client.delete("queues/" + this.name + "/messages/" + id, payload);
        reader.close();
    }

    public void deleteMessages(Ids ids) throws IOException {
        this.deleteMessages(ids.toMessageOptions());
    }

    public void deleteMessages(Messages messages) throws IOException {
        this.deleteMessages(messages.toMessageOptions());
    }

    private void deleteMessages(MessageOptions[] messages) throws IOException {
        String payload = gson.toJson(new MessagesOptions(messages));
        IronReader reader = this.client.delete("queues/" + this.name + "/messages", payload);
        reader.close();
    }

    public void destroy() throws IOException {
        IronReader reader = this.client.delete("queues/" + this.name);
        reader.close();
    }

    public void deleteMessage(Message msg) throws IOException {
        this.deleteMessage(msg.getId(), msg.getReservationId());
    }

    public String push(String msg) throws IOException {
        return this.push(msg, 0L);
    }

    public Ids pushMessages(String[] msg) throws IOException {
        return this.pushMessages(msg, 0L);
    }

    public String push(String msg, long delay) throws IOException {
        Message message = new Message();
        message.setBody(msg);
        message.setDelay(delay);
        Messages msgs = new Messages(message);
        IronReader reader = this.client.post("queues/" + this.name + "/messages", msgs);
        Ids ids = gson.fromJson(reader.reader, Ids.class);
        reader.close();
        return ids.getId(0);
    }

    public Ids pushMessages(String[] msg, long delay) throws IOException {
        ArrayList<Message> messages = new ArrayList<Message>();
        for (String messageName : msg) {
            Message message = new Message();
            message.setBody(messageName);
            message.setDelay(delay);
            messages.add(message);
        }
        MessagesArrayList msgs = new MessagesArrayList(messages);
        IronReader reader = this.client.post("queues/" + this.name + "/messages", msgs);
        Ids ids = gson.fromJson(reader.reader, Ids.class);
        reader.close();
        return ids;
    }

    public void clear() throws IOException {
        IronReader reader = this.client.delete("queues/" + this.name + "/messages", "{}");
        reader.close();
    }

    public String getName() {
        return this.name;
    }

    public QueueModel getInfoAboutQueue() throws IOException {
        IronReader reader = this.client.get("queues/" + this.name);
        QueueContainer queueContainer = gson.fromJson(reader.reader, QueueContainer.class);
        reader.close();
        return queueContainer.getQueue();
    }

    public Message getMessageById(String id) throws IOException {
        String url = "queues/" + this.name + "/messages/" + id;
        IronReader reader = this.client.get(url);
        MessageContainer container = gson.fromJson(reader.reader, MessageContainer.class);
        reader.close();
        return container.getMessage();
    }

    public void releaseMessage(Message message) throws IOException {
        this.releaseMessage(message.getId(), message.getReservationId(), null);
    }

    public void releaseMessage(Message message, int delay) throws IOException {
        this.releaseMessage(message.getId(), message.getReservationId(), new Long(delay));
    }

    public void releaseMessage(String id, String reservationId, Long delay) throws IOException {
        String url = "queues/" + this.name + "/messages/" + id + "/release";
        String payload = gson.toJson(new MessageOptions(reservationId, delay));
        IronReader reader = this.client.post(url, payload);
        reader.close();
    }

    public void addSubscribers(ArrayList<Subscriber> subscribersList) throws IOException {
        this.addSubscribers(new Subscribers(subscribersList));
    }

    public void addSubscribers(Subscriber[] subscribers) throws IOException {
        this.addSubscribers(new Subscribers(subscribers));
    }

    public void addSubscribers(Subscribers subscribers) throws IOException {
        String payload = gson.toJson(subscribers);
        IronReader reader = this.client.post("queues/" + this.name + "/subscribers", payload);
        reader.close();
    }

    public void updateSubscribers(ArrayList<Subscriber> subscribersList) throws IOException {
        this.addSubscribers(subscribersList);
    }

    public void updateSubscribers(Subscriber[] subscribers) throws IOException {
        this.addSubscribers(subscribers);
    }

    public void updateSubscribers(Subscribers subscribers) throws IOException {
        this.addSubscribers(subscribers);
    }

    public void replaceSubscribers(ArrayList<Subscriber> subscribersList) throws IOException {
        this.replaceSubscribers(new Subscribers(subscribersList));
    }

    public void replaceSubscribers(Subscriber[] subscribers) throws IOException {
        this.replaceSubscribers(new Subscribers(subscribers));
    }

    public void replaceSubscribers(Subscribers subscribers) throws IOException {
        String payload = gson.toJson(subscribers);
        IronReader reader = this.client.put("queues/" + this.name + "/subscribers", payload);
        reader.close();
    }

    public void removeSubscribers(ArrayList<Subscriber> subscribersList) throws IOException {
        this.removeSubscribers(new Subscribers(subscribersList));
    }

    public void removeSubscribers(Subscriber[] subscribers) throws IOException {
        this.removeSubscribers(new Subscribers(subscribers));
    }

    public void removeSubscribers(Subscribers subscribers) throws IOException {
        String url = "queues/" + this.name + "/subscribers";
        String jsonMessages = gson.toJson(subscribers);
        IronReader reader = this.client.delete(url, jsonMessages);
        reader.close();
    }

    public SubscribersInfo getPushStatusForMessage(String messageId) throws IOException {
        String url = "queues/" + this.name + "/messages/" + messageId + "/subscribers";
        IronReader reader = this.client.get(url);
        SubscribersInfo subscribersInfo = gson.fromJson(reader.reader, SubscribersInfo.class);
        reader.close();
        return subscribersInfo;
    }

    public void deletePushMessageForSubscriber(String messageId, String reservationId, String subscriberName) throws IOException {
        this.deleteMessage(messageId, reservationId, subscriberName);
    }

    public QueueModel create() throws IOException {
        String url = "queues/" + this.name;
        IronReader reader = this.client.put(url, "{}");
        QueueContainer container = gson.fromJson(reader.reader, QueueContainer.class);
        reader.close();
        return container.getQueue();
    }

    public QueueModel create(ArrayList<Subscriber> subscribersList, ArrayList<Alert> alertsList, String pushType, String errorQueue, int retries, int retriesDelay) throws IOException {
        QueueModel model = new QueueModel();
        model.setPushInfo(new QueuePushModel(subscribersList, retries, retriesDelay, errorQueue));
        model.setAlerts(alertsList);
        model.setType(pushType);
        return this.create(model);
    }

    public QueueModel create(ArrayList<Subscriber> subscribersList, ArrayList<Alert> alertsList, String pushType, int retries, int retriesDelay) throws IOException {
        return this.create(subscribersList, alertsList, pushType, "", retries, retriesDelay);
    }

    public QueueModel create(QueueModel model) throws IOException {
        String url = "queues/" + this.name;
        QueueContainer payload = new QueueContainer(model);
        IronReader reader = this.client.put(url, gson.toJson(payload));
        QueueContainer container = gson.fromJson(reader.reader, QueueContainer.class);
        reader.close();
        return container.getQueue();
    }

    public QueueModel updateQueue(ArrayList<Subscriber> subscribersList, ArrayList<Alert> alertsList, String pushType, String errorQueue, int retries, int retriesDelay) throws IOException {
        QueueModel model = new QueueModel();
        model.setPushInfo(new QueuePushModel(subscribersList, retries, retriesDelay, errorQueue));
        model.setAlerts(alertsList);
        model.setType(pushType);
        return this.update(model);
    }

    public QueueModel updateQueue(ArrayList<Subscriber> subscribersList, ArrayList<Alert> alertsList, String pushType, int retries, int retriesDelay) throws IOException {
        return this.updateQueue(subscribersList, alertsList, pushType, "", retries, retriesDelay);
    }

    public QueueModel update(QueueModel model) throws IOException {
        String url = "queues/" + this.name;
        QueueContainer payload = new QueueContainer(model);
        IronReader reader = this.client.patch(url, gson.toJson(payload));
        QueueContainer container = gson.fromJson(reader.reader, QueueContainer.class);
        reader.close();
        return container.getQueue();
    }

    public QueueModel addAlertsToQueue(ArrayList<Alert> alerts) throws IOException {
        return this.updateAlerts(alerts);
    }

    public QueueModel updateAlertsToQueue(ArrayList<Alert> alerts) throws IOException {
        return this.updateAlerts(alerts);
    }

    public QueueModel updateAlerts(ArrayList<Alert> alerts) throws IOException {
        QueueModel payload = new QueueModel(alerts);
        return this.update(payload);
    }

    public void deleteAlertsFromQueue(ArrayList<Alert> alert_ids) throws IOException {
        String url = "queues/" + this.name + "/alerts";
        Alerts alert = new Alerts(alert_ids);
        String jsonMessages = gson.toJson(alert);
        IronReader reader = this.client.delete(url, jsonMessages);
        reader.close();
    }

    public void deleteAlertFromQueueById(String alert_id) throws IOException {
        String url = "queues/" + this.name + "/alerts/" + alert_id;
        IronReader reader = this.client.delete(url);
        reader.close();
    }

    static class Delay {
        private int delay;

        public Delay(int delay) {
            this.delay = delay;
        }
    }
}

