/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jacksonxml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationModule;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.WrappedFile;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatContentTypeHeader;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dataformat(value="jacksonXml")
public class JacksonXMLDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName,
DataFormatContentTypeHeader,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(JacksonXMLDataFormat.class);
    private CamelContext camelContext;
    private XmlMapper xmlMapper;
    private String collectionTypeName;
    private Class<? extends Collection> collectionType;
    private List<Module> modules;
    private String moduleClassNames;
    private String moduleRefs;
    private String unmarshalTypeName;
    private Class<?> unmarshalType;
    private String jsonViewTypeName;
    private Class<?> jsonView;
    private String include;
    private boolean prettyPrint;
    private boolean allowJmsType;
    private boolean useList;
    private boolean enableJaxbAnnotationModule;
    private String enableFeatures;
    private String disableFeatures;
    private boolean enableJacksonTypeConverter;
    private boolean allowUnmarshallType;
    private boolean contentTypeHeader = true;
    private TimeZone timezone;

    public JacksonXMLDataFormat() {
        this(HashMap.class);
    }

    public JacksonXMLDataFormat(Class<?> unmarshalType) {
        this(unmarshalType, null);
    }

    public JacksonXMLDataFormat(Class<?> unmarshalType, Class<?> jsonView) {
        this(unmarshalType, jsonView, true);
    }

    public JacksonXMLDataFormat(Class<?> unmarshalType, Class<?> jsonView, boolean enableJaxbAnnotationModule) {
        this.unmarshalType = unmarshalType;
        this.jsonView = jsonView;
        this.enableJaxbAnnotationModule = enableJaxbAnnotationModule;
    }

    public JacksonXMLDataFormat(XmlMapper mapper, Class<?> unmarshalType) {
        this(mapper, unmarshalType, null);
    }

    public JacksonXMLDataFormat(XmlMapper mapper, Class<?> unmarshalType, Class<?> jsonView) {
        this.xmlMapper = mapper;
        this.unmarshalType = unmarshalType;
        this.jsonView = jsonView;
    }

    @Override
    public String getDataFormatName() {
        return "jacksonXml";
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        this.xmlMapper.writerWithView(this.jsonView).writeValue(stream, graph);
        if (this.contentTypeHeader) {
            exchange.getMessage().setHeader("Content-Type", "application/xml");
        }
    }

    @Override
    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        return this.unmarshal(exchange, (Object)stream);
    }

    @Override
    public Object unmarshal(Exchange exchange, Object body) throws Exception {
        Object answer;
        ObjectReader reader;
        Class<?> clazz = this.unmarshalType;
        String type = null;
        if (this.allowUnmarshallType) {
            type = exchange.getIn().getHeader("CamelJacksonXmlUnmarshalType", String.class);
        }
        if (type == null && this.isAllowJmsType()) {
            type = exchange.getIn().getHeader("JMSType", String.class);
        }
        if (type != null) {
            clazz = exchange.getContext().getClassResolver().resolveMandatoryClass(type);
        }
        if (this.collectionType != null) {
            CollectionType collType = this.xmlMapper.getTypeFactory().constructCollectionType(this.collectionType, clazz);
            reader = this.xmlMapper.readerFor(collType);
        } else {
            reader = this.xmlMapper.reader().forType(clazz);
        }
        if (body instanceof WrappedFile) {
            body = ((WrappedFile)body).getBody();
        }
        if (body instanceof String) {
            String b = (String)body;
            answer = reader.readValue(b);
        } else if (body instanceof byte[]) {
            byte[] arr = (byte[])body;
            answer = reader.readValue(arr);
        } else if (body instanceof Reader) {
            Reader r = (Reader)body;
            answer = reader.readValue(r);
        } else if (body instanceof File) {
            File f = (File)body;
            answer = reader.readValue(f);
        } else if (body instanceof JsonNode) {
            JsonNode n = (JsonNode)body;
            answer = reader.readValue(n);
        } else {
            InputStream is = exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, body);
            answer = reader.readValue(is);
        }
        return answer;
    }

    public XmlMapper getXmlMapper() {
        return this.xmlMapper;
    }

    public void setXmlMapper(XmlMapper xmlMapper) {
        this.xmlMapper = xmlMapper;
    }

    public String getUnmarshalTypeName() {
        return this.unmarshalTypeName;
    }

    public void setUnmarshalTypeName(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public String getCollectionTypeName() {
        return this.collectionTypeName;
    }

    public void setCollectionTypeName(String collectionTypeName) {
        this.collectionTypeName = collectionTypeName;
    }

    public Class<? extends Collection> getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(Class<? extends Collection> collectionType) {
        this.collectionType = collectionType;
    }

    public String getJsonViewTypeName() {
        return this.jsonViewTypeName;
    }

    public void setJsonViewTypeName(String jsonViewTypeName) {
        this.jsonViewTypeName = jsonViewTypeName;
    }

    public Class<?> getJsonView() {
        return this.jsonView;
    }

    public void setJsonView(Class<?> jsonView) {
        this.jsonView = jsonView;
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public boolean isAllowJmsType() {
        return this.allowJmsType;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public boolean isUseList() {
        return this.useList;
    }

    public void setUseList(boolean useList) {
        this.useList = useList;
    }

    public boolean isEnableJaxbAnnotationModule() {
        return this.enableJaxbAnnotationModule;
    }

    public void setEnableJaxbAnnotationModule(boolean enableJaxbAnnotationModule) {
        this.enableJaxbAnnotationModule = enableJaxbAnnotationModule;
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public void setModules(List<Module> modules) {
        this.modules = modules;
    }

    public String getModuleClassNames() {
        return this.moduleClassNames;
    }

    public void addModule(Module module) {
        if (this.modules == null) {
            this.modules = new ArrayList<Module>();
        }
        this.modules.add(module);
    }

    public void setModuleClassNames(String moduleClassNames) {
        this.moduleClassNames = moduleClassNames;
    }

    public String getModuleRefs() {
        return this.moduleRefs;
    }

    public void setModuleRefs(String moduleRefs) {
        this.moduleRefs = moduleRefs;
    }

    public void useList() {
        this.setCollectionType(ArrayList.class);
    }

    public void useMap() {
        this.setCollectionType(null);
        this.setUnmarshalType(HashMap.class);
    }

    public void setAllowJmsType(boolean allowJmsType) {
        this.allowJmsType = allowJmsType;
    }

    public boolean isEnableJacksonTypeConverter() {
        return this.enableJacksonTypeConverter;
    }

    public void setEnableJacksonTypeConverter(boolean enableJacksonTypeConverter) {
        this.enableJacksonTypeConverter = enableJacksonTypeConverter;
    }

    public boolean isAllowUnmarshallType() {
        return this.allowUnmarshallType;
    }

    public void setAllowUnmarshallType(boolean allowJacksonUnmarshallType) {
        this.allowUnmarshallType = allowJacksonUnmarshallType;
    }

    public boolean isContentTypeHeader() {
        return this.contentTypeHeader;
    }

    @Override
    public void setContentTypeHeader(boolean contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    public TimeZone getTimezone() {
        return this.timezone;
    }

    public void setTimezone(TimeZone timezone) {
        this.timezone = timezone;
    }

    public String getEnableFeatures() {
        return this.enableFeatures;
    }

    public void setEnableFeatures(String enableFeatures) {
        this.enableFeatures = enableFeatures;
    }

    public String getDisableFeatures() {
        return this.disableFeatures;
    }

    public void setDisableFeatures(String disableFeatures) {
        this.disableFeatures = disableFeatures;
    }

    public void enableFeature(SerializationFeature feature) {
        this.enableFeatures = this.enableFeatures == null ? feature.name() : this.enableFeatures + "," + feature.name();
    }

    public void enableFeature(DeserializationFeature feature) {
        this.enableFeatures = this.enableFeatures == null ? feature.name() : this.enableFeatures + "," + feature.name();
    }

    public void enableFeature(MapperFeature feature) {
        this.enableFeatures = this.enableFeatures == null ? feature.name() : this.enableFeatures + "," + feature.name();
    }

    public void enableFeature(FromXmlParser.Feature feature) {
        this.enableFeatures = this.enableFeatures == null ? feature.name() : this.enableFeatures + "," + feature.name();
    }

    public void disableFeature(SerializationFeature feature) {
        this.disableFeatures = this.disableFeatures == null ? feature.name() : this.disableFeatures + "," + feature.name();
    }

    public void disableFeature(DeserializationFeature feature) {
        this.disableFeatures = this.disableFeatures == null ? feature.name() : this.disableFeatures + "," + feature.name();
    }

    public void disableFeature(MapperFeature feature) {
        this.disableFeatures = this.disableFeatures == null ? feature.name() : this.disableFeatures + "," + feature.name();
    }

    public void disableFeature(FromXmlParser.Feature feature) {
        this.disableFeatures = this.disableFeatures == null ? feature.name() : this.disableFeatures + "," + feature.name();
    }

    @Override
    protected void doInit() throws Exception {
        if (this.unmarshalTypeName != null && (this.unmarshalType == null || this.unmarshalType == HashMap.class)) {
            this.unmarshalType = this.camelContext.getClassResolver().resolveClass(this.unmarshalTypeName);
        }
        if (this.jsonViewTypeName != null && this.jsonView == null) {
            this.jsonView = this.camelContext.getClassResolver().resolveClass(this.jsonViewTypeName);
        }
        if (this.collectionTypeName != null && this.collectionType == null) {
            Class<?> clazz = this.camelContext.getClassResolver().resolveClass(this.collectionTypeName);
            this.collectionType = CastUtils.cast(clazz);
        }
    }

    @Override
    protected void doStart() throws Exception {
        String name;
        FromXmlParser.Feature pf;
        MapperFeature mf;
        DeserializationFeature df;
        Iterable<String> it;
        if (this.xmlMapper == null) {
            this.xmlMapper = new XmlMapper();
        }
        if (this.enableJaxbAnnotationModule) {
            JakartaXmlBindAnnotationModule module = new JakartaXmlBindAnnotationModule();
            LOG.info("Registering module: {}", (Object)module);
            this.xmlMapper.registerModule(module);
        }
        if (this.useList) {
            this.setCollectionType(ArrayList.class);
        }
        if (this.include != null) {
            JsonInclude.Include inc = this.getCamelContext().getTypeConverter().mandatoryConvertTo(JsonInclude.Include.class, this.include);
            this.xmlMapper.setSerializationInclusion(inc);
        }
        if (this.prettyPrint) {
            this.xmlMapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
        if (this.enableFeatures != null) {
            it = org.apache.camel.support.ObjectHelper.createIterator(this.enableFeatures);
            while (it.hasNext()) {
                String enable = it.next().toString();
                SerializationFeature serializationFeature = this.getCamelContext().getTypeConverter().tryConvertTo(SerializationFeature.class, enable);
                if (serializationFeature != null) {
                    this.xmlMapper.enable(serializationFeature);
                    continue;
                }
                df = this.getCamelContext().getTypeConverter().tryConvertTo(DeserializationFeature.class, enable);
                if (df != null) {
                    this.xmlMapper.enable(df);
                    continue;
                }
                mf = this.getCamelContext().getTypeConverter().tryConvertTo(MapperFeature.class, enable);
                if (mf != null) {
                    this.xmlMapper.enable(mf);
                    continue;
                }
                pf = this.getCamelContext().getTypeConverter().tryConvertTo(FromXmlParser.Feature.class, enable);
                if (pf != null) {
                    this.xmlMapper.enable(pf);
                    continue;
                }
                throw new IllegalArgumentException("Enable feature: " + enable + " cannot be converted to an accepted enum of types [SerializationFeature,DeserializationFeature,MapperFeature,FromXmlParser.Feature]");
            }
        }
        if (this.disableFeatures != null) {
            it = org.apache.camel.support.ObjectHelper.createIterator(this.disableFeatures);
            while (it.hasNext()) {
                String disable = it.next().toString();
                SerializationFeature serializationFeature = this.getCamelContext().getTypeConverter().tryConvertTo(SerializationFeature.class, disable);
                if (serializationFeature != null) {
                    this.xmlMapper.disable(serializationFeature);
                    continue;
                }
                df = this.getCamelContext().getTypeConverter().tryConvertTo(DeserializationFeature.class, disable);
                if (df != null) {
                    this.xmlMapper.disable(df);
                    continue;
                }
                mf = this.getCamelContext().getTypeConverter().tryConvertTo(MapperFeature.class, disable);
                if (mf != null) {
                    this.xmlMapper.disable(mf);
                    continue;
                }
                pf = this.getCamelContext().getTypeConverter().tryConvertTo(FromXmlParser.Feature.class, disable);
                if (pf != null) {
                    this.xmlMapper.disable(pf);
                    continue;
                }
                throw new IllegalArgumentException("Disable feature: " + disable + " cannot be converted to an accepted enum of types [SerializationFeature,DeserializationFeature,MapperFeature,FromXmlParser.Feature]");
            }
        }
        if (this.modules != null) {
            for (Module module : this.modules) {
                LOG.info("Registering module: {}", (Object)module);
                this.xmlMapper.registerModules(module);
            }
        }
        if (this.moduleClassNames != null) {
            it = org.apache.camel.support.ObjectHelper.createIterable(this.moduleClassNames);
            for (Object object : it) {
                name = object.toString();
                Class<Module> clazz = this.camelContext.getClassResolver().resolveMandatoryClass(name, Module.class);
                Module module = this.camelContext.getInjector().newInstance(clazz);
                LOG.info("Registering module: {} -> {}", (Object)name, (Object)module);
                this.xmlMapper.registerModule(module);
            }
        }
        if (this.moduleRefs != null) {
            it = org.apache.camel.support.ObjectHelper.createIterable(this.moduleRefs);
            for (Object object : it) {
                name = object.toString();
                if (name.startsWith("#")) {
                    name = name.substring(1);
                }
                Module module = CamelContextHelper.mandatoryLookup(this.camelContext, name, Module.class);
                LOG.info("Registering module: {} -> {}", (Object)name, (Object)module);
                this.xmlMapper.registerModule(module);
            }
        }
        if (ObjectHelper.isNotEmpty(this.timezone)) {
            LOG.debug("Setting timezone to XML Mapper: {}", (Object)this.timezone);
            this.xmlMapper.setTimeZone(this.timezone);
        }
    }

    @Override
    protected void doStop() throws Exception {
    }
}

