/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxb;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.JAXBIntrospector;
import jakarta.xml.bind.MarshalException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.Unmarshaller;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConverter;
import org.apache.camel.converter.jaxb.FilteringXmlStreamWriter;
import org.apache.camel.converter.jaxb.JaxbHelper;
import org.apache.camel.converter.jaxb.JaxbNamespacePrefixMapper;
import org.apache.camel.converter.jaxb.JaxbXmlStreamWriterWrapper;
import org.apache.camel.converter.jaxb.NamespacePrefixMapperFactory;
import org.apache.camel.converter.jaxb.NonXmlFilterReader;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatContentTypeHeader;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Dataformat(value="jaxb")
public class JaxbDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName,
DataFormatContentTypeHeader,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(JaxbDataFormat.class);
    private SchemaFactory schemaFactory;
    private CamelContext camelContext;
    private JAXBContext context;
    private JAXBIntrospector introspector;
    private String contextPath;
    private boolean contextPathIsClassName;
    private String schema;
    private int schemaSeverityLevel;
    private String schemaLocation;
    private String noNamespaceSchemaLocation;
    private boolean prettyPrint = true;
    private boolean objectFactory = true;
    private boolean ignoreJAXBElement = true;
    private boolean mustBeJAXBElement;
    private boolean filterNonXmlChars;
    private String encoding;
    private boolean fragment;
    private QName partNamespace;
    private Class<?> partClass;
    private Map<String, String> namespacePrefix;
    private JaxbNamespacePrefixMapper namespacePrefixMapper;
    private JaxbXmlStreamWriterWrapper xmlStreamWriterWrapper;
    private TypeConverter typeConverter;
    private Schema cachedSchema;
    private Map<String, Object> jaxbProviderProperties;
    private boolean contentTypeHeader = true;
    private String accessExternalSchemaProtocols;

    public JaxbDataFormat() {
    }

    public JaxbDataFormat(JAXBContext context) {
        this.context = context;
    }

    public JaxbDataFormat(String contextPath) {
        this.contextPath = contextPath;
    }

    @Override
    public String getDataFormatName() {
        return "jaxb";
    }

    @Override
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws IOException {
        try {
            String charset;
            Marshaller marshaller = this.createMarshaller();
            if (this.isPrettyPrint()) {
                marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
            }
            if ((charset = exchange.getProperty(ExchangePropertyKey.CHARSET_NAME, String.class)) == null && (charset = this.encoding) != null) {
                exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)charset);
            }
            if (charset != null) {
                marshaller.setProperty("jaxb.encoding", charset);
            }
            if (this.isFragment()) {
                marshaller.setProperty("jaxb.fragment", Boolean.TRUE);
            }
            if (ObjectHelper.isNotEmpty(this.schemaLocation)) {
                marshaller.setProperty("jaxb.schemaLocation", this.schemaLocation);
            }
            if (ObjectHelper.isNotEmpty(this.noNamespaceSchemaLocation)) {
                marshaller.setProperty("jaxb.noNamespaceSchemaLocation", this.noNamespaceSchemaLocation);
            }
            if (this.namespacePrefixMapper != null) {
                marshaller.setProperty(this.namespacePrefixMapper.getRegistrationKey(), this.namespacePrefixMapper);
            }
            this.injectCustomProperties(exchange, marshaller);
            this.doMarshal(exchange, graph, stream, marshaller, charset);
            if (this.contentTypeHeader) {
                exchange.getMessage().setHeader("Content-Type", "application/xml");
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void injectCustomProperties(Exchange exchange, Marshaller marshaller) throws PropertyException {
        Map<String, Object> customProperties = exchange.getProperty("CamelJaxbProviderProperties", Map.class);
        if (customProperties == null) {
            customProperties = this.getJaxbProviderProperties();
        }
        if (customProperties != null) {
            for (Map.Entry<String, Object> property : customProperties.entrySet()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using JAXB Provider Property {}={}", (Object)property.getKey(), property.getValue());
                }
                marshaller.setProperty(property.getKey(), property.getValue());
            }
        }
    }

    void doMarshal(Exchange exchange, Object graph, OutputStream stream, Marshaller marshaller, String charset) throws Exception {
        Object element = graph;
        QName partNamespaceOnDataFormat = this.getPartNamespace();
        String partClassFromHeader = exchange.getIn().getHeader("CamelJaxbPartClass", String.class);
        String partNamespaceFromHeader = exchange.getIn().getHeader("CamelJaxbPartNamespace", String.class);
        if (!(this.partClass == null && partClassFromHeader == null || partNamespaceOnDataFormat == null && partNamespaceFromHeader == null)) {
            element = this.toElement(graph, partClassFromHeader, partNamespaceFromHeader, partNamespaceOnDataFormat);
        }
        if (this.introspector.isElement(element)) {
            this.tryMarshal(exchange, stream, marshaller, charset, element);
            return;
        }
        if (this.objectFactory && element != null && this.tryFromFactory(exchange, stream, marshaller, charset, element)) {
            return;
        }
        if (this.mustBeJAXBElement) {
            throw new InvalidPayloadException(exchange, JAXBElement.class);
        }
        JaxbDataFormat.writeGraph(exchange, graph, stream);
    }

    private boolean tryFromFactory(Exchange exchange, OutputStream stream, Marshaller marshaller, String charset, Object element) throws IllegalAccessException, InvocationTargetException, JAXBException, InstantiationException {
        Method objectFactoryMethod = JaxbHelper.getJaxbElementFactoryMethod(this.camelContext, element.getClass());
        if (objectFactoryMethod != null) {
            try {
                this.tryMarshallFromInstance(exchange, stream, marshaller, charset, objectFactoryMethod, element);
                return true;
            }
            catch (Exception e) {
                if (MarshalException.class.isAssignableFrom(e.getClass()) && this.schema != null) {
                    throw e;
                }
                LOG.debug("Unable to create JAXBElement object for type {} due to {}", new Object[]{element.getClass(), e.getMessage(), e});
            }
        }
        return false;
    }

    private static void writeGraph(Exchange exchange, Object graph, OutputStream stream) throws NoTypeConversionAvailableException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attempt to marshalling non JAXBElement with type {} as InputStream", (Object)ObjectHelper.classCanonicalName(graph));
        }
        InputStream is = exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, graph);
        IOHelper.copyAndCloseInput(is, stream);
    }

    private void tryMarshallFromInstance(Exchange exchange, OutputStream stream, Marshaller marshaller, String charset, Method objectFactoryMethod, Object element) throws IllegalAccessException, InvocationTargetException, JAXBException, InstantiationException {
        Object instance = objectFactoryMethod.getDeclaringClass().newInstance();
        Object toMarshall = objectFactoryMethod.invoke(instance, element);
        if (this.asXmlStreamWriter(exchange)) {
            XMLStreamWriter writer = this.typeConverter.convertTo(XMLStreamWriter.class, exchange, stream);
            if (this.needFiltering(exchange)) {
                writer = new FilteringXmlStreamWriter(writer, charset);
            }
            if (this.xmlStreamWriterWrapper != null) {
                writer = this.xmlStreamWriterWrapper.wrapWriter(writer);
            }
            marshaller.marshal(toMarshall, writer);
        } else {
            marshaller.marshal(toMarshall, stream);
        }
    }

    private void tryMarshal(Exchange exchange, OutputStream stream, Marshaller marshaller, String charset, Object element) throws JAXBException {
        if (this.asXmlStreamWriter(exchange)) {
            XMLStreamWriter writer = this.typeConverter.convertTo(XMLStreamWriter.class, exchange, stream);
            if (this.needFiltering(exchange)) {
                writer = new FilteringXmlStreamWriter(writer, charset);
            }
            if (this.xmlStreamWriterWrapper != null) {
                writer = this.xmlStreamWriterWrapper.wrapWriter(writer);
            }
            marshaller.marshal(element, writer);
        } else {
            marshaller.marshal(element, stream);
        }
    }

    private Object toElement(Object graph, String partClassFromHeader, String partNamespaceFromHeader, QName partNamespaceOnDataFormat) throws JAXBException {
        if (partClassFromHeader != null) {
            try {
                this.partClass = this.camelContext.getClassResolver().resolveMandatoryClass(partClassFromHeader, Object.class);
            }
            catch (ClassNotFoundException e) {
                throw new JAXBException(e);
            }
        }
        if (partNamespaceFromHeader != null) {
            partNamespaceOnDataFormat = QName.valueOf(partNamespaceFromHeader);
        }
        return new JAXBElement<Object>(partNamespaceOnDataFormat, this.partClass, graph);
    }

    private boolean asXmlStreamWriter(Exchange exchange) {
        return this.needFiltering(exchange) || this.xmlStreamWriterWrapper != null;
    }

    @Override
    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        return this.unmarshal(exchange, (Object)stream);
    }

    @Override
    public Object unmarshal(Exchange exchange, Object body) throws Exception {
        try {
            JAXBElement<?> answer;
            XMLStreamReader xmlReader;
            if (this.needFiltering(exchange)) {
                xmlReader = this.typeConverter.convertTo(XMLStreamReader.class, exchange, this.createNonXmlFilterReader(exchange, body));
            } else {
                xmlReader = this.typeConverter.tryConvertTo(XMLStreamReader.class, exchange, body);
                if (xmlReader == null) {
                    InputStream is = this.getCamelContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, body);
                    xmlReader = this.typeConverter.convertTo(XMLStreamReader.class, exchange, is);
                }
            }
            String partClassFromHeader = exchange.getIn().getHeader("CamelJaxbPartClass", String.class);
            if (this.partClass != null || partClassFromHeader != null) {
                if (partClassFromHeader != null) {
                    try {
                        this.partClass = this.camelContext.getClassResolver().resolveMandatoryClass(partClassFromHeader, Object.class);
                    }
                    catch (ClassNotFoundException e) {
                        throw new JAXBException(e);
                    }
                }
                answer = this.createUnmarshaller().unmarshal(xmlReader, this.partClass);
            } else {
                answer = this.createUnmarshaller().unmarshal(xmlReader);
            }
            if (answer instanceof JAXBElement && this.isIgnoreJAXBElement()) {
                answer = answer.getValue();
            }
            return answer;
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    private NonXmlFilterReader createNonXmlFilterReader(Exchange exchange, Object body) throws NoTypeConversionAvailableException {
        Reader reader = this.getCamelContext().getTypeConverter().tryConvertTo(Reader.class, exchange, body);
        if (reader == null) {
            InputStream is = this.getCamelContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, body);
            reader = new InputStreamReader(is);
        }
        return new NonXmlFilterReader(reader);
    }

    protected boolean needFiltering(Exchange exchange) {
        return exchange == null ? this.filterNonXmlChars : exchange.getProperty("CamelFilterNonXmlChars", (Object)this.filterNonXmlChars, Boolean.class);
    }

    public boolean isIgnoreJAXBElement() {
        return this.ignoreJAXBElement;
    }

    public void setIgnoreJAXBElement(boolean flag) {
        this.ignoreJAXBElement = flag;
    }

    public boolean isMustBeJAXBElement() {
        return this.mustBeJAXBElement;
    }

    public void setMustBeJAXBElement(boolean mustBeJAXBElement) {
        this.mustBeJAXBElement = mustBeJAXBElement;
    }

    public JAXBContext getContext() {
        return this.context;
    }

    public void setContext(JAXBContext context) {
        this.context = context;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public boolean isContextPathIsClassName() {
        return this.contextPathIsClassName;
    }

    public void setContextPathIsClassName(boolean contextPathIsClassName) {
        this.contextPathIsClassName = contextPathIsClassName;
    }

    public SchemaFactory getSchemaFactory() throws SAXException {
        return this.schemaFactory;
    }

    public void setSchemaFactory(SchemaFactory schemaFactory) {
        this.schemaFactory = schemaFactory;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public int getSchemaSeverityLevel() {
        return this.schemaSeverityLevel;
    }

    public void setSchemaSeverityLevel(int schemaSeverityLevel) {
        this.schemaSeverityLevel = schemaSeverityLevel;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public boolean isObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(boolean objectFactory) {
        this.objectFactory = objectFactory;
    }

    public boolean isFragment() {
        return this.fragment;
    }

    public void setFragment(boolean fragment) {
        this.fragment = fragment;
    }

    public boolean isFilterNonXmlChars() {
        return this.filterNonXmlChars;
    }

    public void setFilterNonXmlChars(boolean filterNonXmlChars) {
        this.filterNonXmlChars = filterNonXmlChars;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public QName getPartNamespace() {
        return this.partNamespace;
    }

    public void setPartNamespace(QName partNamespace) {
        this.partNamespace = partNamespace;
    }

    public Class<?> getPartClass() {
        return this.partClass;
    }

    public void setPartClass(Class<?> partClass) {
        this.partClass = partClass;
    }

    public Map<String, String> getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public void setNamespacePrefix(Map<String, String> namespacePrefix) {
        this.namespacePrefix = namespacePrefix;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public JaxbXmlStreamWriterWrapper getXmlStreamWriterWrapper() {
        return this.xmlStreamWriterWrapper;
    }

    public void setXmlStreamWriterWrapper(JaxbXmlStreamWriterWrapper xmlStreamWriterWrapper) {
        this.xmlStreamWriterWrapper = xmlStreamWriterWrapper;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public String getNoNamespaceSchemaLocation() {
        return this.noNamespaceSchemaLocation;
    }

    public void setNoNamespaceSchemaLocation(String schemaLocation) {
        this.noNamespaceSchemaLocation = schemaLocation;
    }

    public Map<String, Object> getJaxbProviderProperties() {
        return this.jaxbProviderProperties;
    }

    public void setJaxbProviderProperties(Map<String, Object> jaxbProviderProperties) {
        this.jaxbProviderProperties = jaxbProviderProperties;
    }

    public boolean isContentTypeHeader() {
        return this.contentTypeHeader;
    }

    @Override
    public void setContentTypeHeader(boolean contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    public String getAccessExternalSchemaProtocols() {
        return this.accessExternalSchemaProtocols;
    }

    public void setAccessExternalSchemaProtocols(String accessExternalSchemaProtocols) {
        this.accessExternalSchemaProtocols = accessExternalSchemaProtocols;
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.camelContext, "CamelContext");
        if (this.context == null) {
            this.context = this.createContext();
        }
        this.introspector = this.context.createJAXBIntrospector();
        if (this.namespacePrefix != null) {
            this.namespacePrefixMapper = NamespacePrefixMapperFactory.newNamespacePrefixMapper(this.camelContext, this.namespacePrefix);
        }
        this.typeConverter = this.camelContext.getTypeConverter();
        if (this.schema != null) {
            this.cachedSchema = this.createSchema(this.getSources());
        }
        LOG.debug("JaxbDataFormat [prettyPrint={}, objectFactory={}]", (Object)this.prettyPrint, (Object)this.objectFactory);
    }

    @Override
    protected void doStop() throws Exception {
    }

    protected JAXBContext createContext() throws Exception {
        if (this.contextPath != null) {
            ClassLoader cl = this.camelContext.getApplicationContextClassLoader();
            if (cl != null) {
                if (this.contextPathIsClassName) {
                    LOG.debug("Creating JAXBContext with className: {} and ApplicationContextClassLoader: {}", (Object)this.contextPath, (Object)cl);
                    Class<?> clazz = this.camelContext.getClassResolver().resolveMandatoryClass(this.contextPath, cl);
                    return JAXBContext.newInstance(clazz);
                }
                LOG.debug("Creating JAXBContext with contextPath: {} and ApplicationContextClassLoader: {}", (Object)this.contextPath, (Object)cl);
                return JAXBContext.newInstance(this.contextPath, cl);
            }
            if (this.contextPathIsClassName) {
                LOG.debug("Creating JAXBContext with className: {}", (Object)this.contextPath);
                Class<?> clazz = this.camelContext.getClassResolver().resolveMandatoryClass(this.contextPath);
                return JAXBContext.newInstance(clazz);
            }
            LOG.debug("Creating JAXBContext with contextPath: {}", (Object)this.contextPath);
            return JAXBContext.newInstance(this.contextPath);
        }
        LOG.debug("Creating JAXBContext");
        return JAXBContext.newInstance(new Class[0]);
    }

    protected Unmarshaller createUnmarshaller() throws JAXBException {
        Unmarshaller unmarshaller = this.getContext().createUnmarshaller();
        if (this.schema != null) {
            unmarshaller.setSchema(this.cachedSchema);
            unmarshaller.setEventHandler(event -> event.getSeverity() < this.getSchemaSeverityLevel());
        }
        return unmarshaller;
    }

    protected Marshaller createMarshaller() throws JAXBException {
        Marshaller marshaller = this.getContext().createMarshaller();
        if (this.schema != null) {
            marshaller.setSchema(this.cachedSchema);
            marshaller.setEventHandler(event -> event.getSeverity() < this.getSchemaSeverityLevel());
        }
        return marshaller;
    }

    private Schema createSchema(Source[] sources) throws SAXException {
        SchemaFactory factory = JaxbDataFormat.createSchemaFactory(this.accessExternalSchemaProtocols);
        return factory.newSchema(sources);
    }

    private Source[] getSources() throws FileNotFoundException, MalformedURLException {
        String[] schemas = this.schema.split(",");
        Source[] sources = new Source[schemas.length];
        for (int i = 0; i < schemas.length; ++i) {
            URL schemaUrl = ResourceHelper.resolveMandatoryResourceAsUrl(this.camelContext, schemas[i]);
            sources[i] = new StreamSource(schemaUrl.toExternalForm());
        }
        return sources;
    }

    private static SchemaFactory createSchemaFactory(String protocols) throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        if (protocols == null || "false".equals(protocols) || "none".equals(protocols)) {
            protocols = "";
            LOG.debug("Configuring SchemaFactory to not allow access to external DTD/Schema");
        } else {
            LOG.debug("Configuring SchemaFactory to allow access to external DTD/Schema using protocols: {}", (Object)protocols);
        }
        factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", protocols);
        factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", protocols);
        return factory;
    }
}

