/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcache;

import java.util.List;
import java.util.Properties;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.jcache.JCacheEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class JCacheEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        JCacheEndpoint target = (JCacheEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "action": {
                target.getConfiguration().setAction(JCacheEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(JCacheEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "cacheconfiguration": 
            case "cacheConfiguration": {
                target.getConfiguration().setCacheConfiguration(JCacheEndpointConfigurer.property(camelContext, Configuration.class, value));
                return true;
            }
            case "cacheconfigurationproperties": 
            case "cacheConfigurationProperties": {
                target.getConfiguration().setCacheConfigurationProperties(JCacheEndpointConfigurer.property(camelContext, Properties.class, value));
                return true;
            }
            case "cacheloaderfactory": 
            case "cacheLoaderFactory": {
                target.getConfiguration().setCacheLoaderFactory(JCacheEndpointConfigurer.property(camelContext, Factory.class, value));
                return true;
            }
            case "cachewriterfactory": 
            case "cacheWriterFactory": {
                target.getConfiguration().setCacheWriterFactory(JCacheEndpointConfigurer.property(camelContext, Factory.class, value));
                return true;
            }
            case "cachingprovider": 
            case "cachingProvider": {
                target.getConfiguration().setCachingProvider(JCacheEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "configurationuri": 
            case "configurationUri": {
                target.getConfiguration().setConfigurationUri(JCacheEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "createcacheifnotexists": 
            case "createCacheIfNotExists": {
                target.getConfiguration().setCreateCacheIfNotExists(JCacheEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "eventfilters": 
            case "eventFilters": {
                target.getConfiguration().setEventFilters(JCacheEndpointConfigurer.property(camelContext, List.class, value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler(JCacheEndpointConfigurer.property(camelContext, ExceptionHandler.class, value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern(JCacheEndpointConfigurer.property(camelContext, ExchangePattern.class, value));
                return true;
            }
            case "expirypolicyfactory": 
            case "expiryPolicyFactory": {
                target.getConfiguration().setExpiryPolicyFactory(JCacheEndpointConfigurer.property(camelContext, Factory.class, value));
                return true;
            }
            case "filteredevents": 
            case "filteredEvents": {
                target.getConfiguration().setFilteredEvents(JCacheEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(JCacheEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "lookupproviders": 
            case "lookupProviders": {
                target.getConfiguration().setLookupProviders(JCacheEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "managementenabled": 
            case "managementEnabled": {
                target.getConfiguration().setManagementEnabled(JCacheEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "oldvaluerequired": 
            case "oldValueRequired": {
                target.getConfiguration().setOldValueRequired(JCacheEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "readthrough": 
            case "readThrough": {
                target.getConfiguration().setReadThrough(JCacheEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "statisticsenabled": 
            case "statisticsEnabled": {
                target.getConfiguration().setStatisticsEnabled(JCacheEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "storebyvalue": 
            case "storeByValue": {
                target.getConfiguration().setStoreByValue(JCacheEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "synchronous": {
                target.getConfiguration().setSynchronous(JCacheEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "writethrough": 
            case "writeThrough": {
                target.getConfiguration().setWriteThrough(JCacheEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "action": {
                return String.class;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "cacheconfiguration": 
            case "cacheConfiguration": {
                return Configuration.class;
            }
            case "cacheconfigurationproperties": 
            case "cacheConfigurationProperties": {
                return Properties.class;
            }
            case "cacheloaderfactory": 
            case "cacheLoaderFactory": {
                return Factory.class;
            }
            case "cachewriterfactory": 
            case "cacheWriterFactory": {
                return Factory.class;
            }
            case "cachingprovider": 
            case "cachingProvider": {
                return String.class;
            }
            case "configurationuri": 
            case "configurationUri": {
                return String.class;
            }
            case "createcacheifnotexists": 
            case "createCacheIfNotExists": {
                return Boolean.TYPE;
            }
            case "eventfilters": 
            case "eventFilters": {
                return List.class;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return ExceptionHandler.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "expirypolicyfactory": 
            case "expiryPolicyFactory": {
                return Factory.class;
            }
            case "filteredevents": 
            case "filteredEvents": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "lookupproviders": 
            case "lookupProviders": {
                return Boolean.TYPE;
            }
            case "managementenabled": 
            case "managementEnabled": {
                return Boolean.TYPE;
            }
            case "oldvaluerequired": 
            case "oldValueRequired": {
                return Boolean.TYPE;
            }
            case "readthrough": 
            case "readThrough": {
                return Boolean.TYPE;
            }
            case "statisticsenabled": 
            case "statisticsEnabled": {
                return Boolean.TYPE;
            }
            case "storebyvalue": 
            case "storeByValue": {
                return Boolean.TYPE;
            }
            case "synchronous": {
                return Boolean.TYPE;
            }
            case "writethrough": 
            case "writeThrough": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        JCacheEndpoint target = (JCacheEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "action": {
                return target.getConfiguration().getAction();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "cacheconfiguration": 
            case "cacheConfiguration": {
                return target.getConfiguration().getCacheConfiguration();
            }
            case "cacheconfigurationproperties": 
            case "cacheConfigurationProperties": {
                return target.getConfiguration().getCacheConfigurationProperties();
            }
            case "cacheloaderfactory": 
            case "cacheLoaderFactory": {
                return target.getConfiguration().getCacheLoaderFactory();
            }
            case "cachewriterfactory": 
            case "cacheWriterFactory": {
                return target.getConfiguration().getCacheWriterFactory();
            }
            case "cachingprovider": 
            case "cachingProvider": {
                return target.getConfiguration().getCachingProvider();
            }
            case "configurationuri": 
            case "configurationUri": {
                return target.getConfiguration().getConfigurationUri();
            }
            case "createcacheifnotexists": 
            case "createCacheIfNotExists": {
                return target.getConfiguration().isCreateCacheIfNotExists();
            }
            case "eventfilters": 
            case "eventFilters": {
                return target.getConfiguration().getEventFilters();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "expirypolicyfactory": 
            case "expiryPolicyFactory": {
                return target.getConfiguration().getExpiryPolicyFactory();
            }
            case "filteredevents": 
            case "filteredEvents": {
                return target.getConfiguration().getFilteredEvents();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "lookupproviders": 
            case "lookupProviders": {
                return target.getConfiguration().isLookupProviders();
            }
            case "managementenabled": 
            case "managementEnabled": {
                return target.getConfiguration().isManagementEnabled();
            }
            case "oldvaluerequired": 
            case "oldValueRequired": {
                return target.getConfiguration().isOldValueRequired();
            }
            case "readthrough": 
            case "readThrough": {
                return target.getConfiguration().isReadThrough();
            }
            case "statisticsenabled": 
            case "statisticsEnabled": {
                return target.getConfiguration().isStatisticsEnabled();
            }
            case "storebyvalue": 
            case "storeByValue": {
                return target.getConfiguration().isStoreByValue();
            }
            case "synchronous": {
                return target.getConfiguration().isSynchronous();
            }
            case "writethrough": 
            case "writeThrough": {
                return target.getConfiguration().isWriteThrough();
            }
        }
        return null;
    }

    @Override
    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "cacheloaderfactory": 
            case "cacheLoaderFactory": {
                return CacheLoader.class;
            }
            case "cachewriterfactory": 
            case "cacheWriterFactory": {
                return CacheWriter.class;
            }
            case "eventfilters": 
            case "eventFilters": {
                return CacheEntryEventFilter.class;
            }
            case "expirypolicyfactory": 
            case "expiryPolicyFactory": {
                return ExpiryPolicy.class;
            }
        }
        return null;
    }
}

