/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcache;

import java.lang.reflect.Proxy;
import org.apache.camel.CamelContext;
import org.apache.camel.component.jcache.DefaultJCacheManagerFactory;
import org.apache.camel.component.jcache.JCacheConfiguration;
import org.apache.camel.component.jcache.JCacheManager;
import org.apache.camel.component.jcache.JCacheManagerFactory;
import org.apache.camel.support.CamelContextHelper;

public final class JCacheHelper {
    private JCacheHelper() {
    }

    public static <K, V> JCacheManager<K, V> createManager(CamelContext camelContext, JCacheConfiguration configuration) {
        JCacheManagerFactory factory = CamelContextHelper.findSingleByType(camelContext, JCacheManagerFactory.class);
        if (factory == null) {
            factory = new DefaultJCacheManagerFactory();
        }
        return factory.createManager(configuration);
    }

    public static <T> T tcclProxy(T instance, Class<T> type, ClassLoader classLoader) {
        return (T)Proxy.newProxyInstance(JCacheHelper.class.getClassLoader(), new Class[]{type}, (proxy, method, args) -> {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                Object object = method.invoke(instance, args);
                return object;
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        });
    }
}

