/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcache;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.processor.EntryProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.jcache.JCacheConfiguration;
import org.apache.camel.component.jcache.JCacheEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public class JCacheProducer
extends DefaultProducer {
    private final JCacheConfiguration configuration;

    public JCacheProducer(JCacheEndpoint endpoint, JCacheConfiguration configuration) {
        super(endpoint);
        this.configuration = configuration;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String actionName = exchange.getIn().getHeader("CamelJCacheAction", String.class);
        if (actionName == null) {
            actionName = this.configuration.getAction();
        }
        StringHelper.notEmpty(actionName, "CamelJCacheAction");
        Action action = Action.fromName(actionName);
        if (action == null) {
            throw new IllegalArgumentException(String.format("The value '%s' is not allowed for parameter '%s'", actionName, "CamelJCacheAction"));
        }
        Cache<Object, Object> cache = this.getJCacheEndpoint().getManager().getCache();
        action.validate(cache, exchange);
        action.execute(cache, exchange);
    }

    @Override
    protected void doStart() throws Exception {
        this.getCache();
        super.doStart();
    }

    private JCacheEndpoint getJCacheEndpoint() {
        return (JCacheEndpoint)this.getEndpoint();
    }

    private Cache getCache() throws Exception {
        return this.getJCacheEndpoint().getManager().getCache();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Action {
        PUT{

            @Override
            void validate(Cache<Object, Object> cache, Exchange exchange) throws Exception {
                this.headerIsNotNull(exchange, "CamelJCacheKey");
            }

            @Override
            void execute(Cache<Object, Object> cache, Exchange exchange) {
                cache.put(exchange.getIn().getHeader("CamelJCacheKey"), exchange.getIn().getBody());
            }
        }
        ,
        PUTALL{

            @Override
            void validate(Cache<Object, Object> cache, Exchange exchange) throws Exception {
            }

            @Override
            void execute(Cache<Object, Object> cache, Exchange exchange) {
                cache.putAll(exchange.getIn().getBody(Map.class));
            }
        }
        ,
        PUTIFABSENT{

            @Override
            void validate(Cache<Object, Object> cache, Exchange exchange) throws Exception {
                this.headerIsNotNull(exchange, "CamelJCacheKey");
            }

            @Override
            void execute(Cache<Object, Object> cache, Exchange exchange) {
                exchange.getIn().setHeader("CamelJCacheResult", cache.putIfAbsent(exchange.getIn().getHeader("CamelJCacheKey"), exchange.getIn().getBody()));
            }
        }
        ,
        GET{

            @Override
            void validate(Cache<Object, Object> cache, Exchange exchange) throws Exception {
                this.headerIsNotNull(exchange, "CamelJCacheKey");
            }

            @Override
            void execute(Cache<Object, Object> cache, Exchange exchange) {
                exchange.getIn().setBody(cache.get(exchange.getIn().getHeader("CamelJCacheKey")));
            }
        }
        ,
        GETALL{

            @Override
            void validate(Cache<Object, Object> cache, Exchange exchange) throws Exception {
                this.headerIsNotNull(exchange, "CamelJCacheKeys");
            }

            @Override
            void execute(Cache<Object, Object> cache, Exchange exchange) {
                exchange.getIn().setBody(cache.getAll(exchange.getIn().getHeader("CamelJCacheKeys", Set.class)));
            }
        }
        ,
        GETANDREMOVE{

            @Override
            void validate(Cache<Object, Object> cache, Exchange exchange) throws Exception {
                this.headerIsNotNull(exchange, "CamelJCacheKey");
            }

            @Override
            void execute(Cache<Object, Object> cache, Exchange exchange) {
                exchange.getIn().setBody(cache.getAndRemove(exchange.getIn().getHeader("CamelJCacheKey")));
            }
        }
        ,
        GETANDREPLACE{

            @Override
            void validate(Cache<Object, Object> cache, Exchange exchange) throws Exception {
                this.headerIsNotNull(exchange, "CamelJCacheKey");
            }

            @Override
            void execute(Cache<Object, Object> cache, Exchange exchange) {
                exchange.getIn().setBody(cache.getAndReplace(exchange.getIn().getHeader("CamelJCacheKey"), exchange.getIn().getBody()));
            }
        }
        ,
        GETANDPUT{

            @Override
            void validate(Cache<Object, Object> cache, Exchange exchange) throws Exception {
                this.headerIsNotNull(exchange, "CamelJCacheKey");
            }

            @Override
            void execute(Cache<Object, Object> cache, Exchange exchange) {
                exchange.getIn().setBody(cache.getAndPut(exchange.getIn().getHeader("CamelJCacheKey"), exchange.getIn().getBody()));
            }
        }
        ,
        REPLACE{

            @Override
            void validate(Cache<Object, Object> cache, Exchange exchange) throws Exception {
                this.headerIsNotNull(exchange, "CamelJCacheKey");
            }

            @Override
            void execute(Cache<Object, Object> cache, Exchange exchange) {
                Object oldValue = exchange.getIn().getHeader("CamelJCacheOldValue");
                exchange.getIn().setHeader("CamelJCacheResult", oldValue != null ? cache.replace(exchange.getIn().getHeader("CamelJCacheKey"), oldValue, exchange.getIn().getBody()) : cache.replace(exchange.getIn().getHeader("CamelJCacheKey"), exchange.getIn().getBody()));
            }
        }
        ,
        REMOVE{

            @Override
            void validate(Cache<Object, Object> cache, Exchange exchange) throws Exception {
                this.headerIsNotNull(exchange, "CamelJCacheKey");
            }

            @Override
            void execute(Cache<Object, Object> cache, Exchange exchange) {
                Object oldValue = exchange.getIn().getHeader("CamelJCacheOldValue");
                exchange.getIn().setHeader("CamelJCacheResult", oldValue != null ? cache.remove(exchange.getIn().getHeader("CamelJCacheKey"), oldValue) : cache.remove(exchange.getIn().getHeader("CamelJCacheKey")));
            }
        }
        ,
        REMOVEALL{

            @Override
            void validate(Cache<Object, Object> cache, Exchange exchange) throws Exception {
            }

            @Override
            void execute(Cache<Object, Object> cache, Exchange exchange) {
                Set keys = exchange.getIn().getHeader("CamelJCacheKeys", Set.class);
                if (keys != null) {
                    cache.removeAll(keys);
                } else {
                    cache.removeAll();
                }
            }
        }
        ,
        INVOKE{

            @Override
            void validate(Cache<Object, Object> cache, Exchange exchange) throws Exception {
                this.headerIsNotNull(exchange, "CamelJCacheEntryProcessor");
                if (exchange.getIn().getHeader("CamelJCacheKeys") == null && exchange.getIn().getHeader("CamelJCacheKey") == null) {
                    throw new IllegalArgumentException(String.format("Either %s or %s must be set for action %s", "CamelJCacheKeys", "CamelJCacheKey", this.name()));
                }
            }

            @Override
            void execute(Cache<Object, Object> cache, Exchange exchange) {
                Message message = exchange.getIn();
                Set keys = message.getHeader("CamelJCacheKeys", Set.class);
                EntryProcessor entryProcessor = message.getHeader("CamelJCacheEntryProcessor", EntryProcessor.class);
                List arguments = message.getHeader("CamelJCacheEntryArgs", Collection.class);
                if (arguments == null) {
                    arguments = Collections.emptyList();
                }
                message.setBody(keys != null ? cache.invokeAll(keys, entryProcessor, arguments) : cache.invoke(exchange.getIn().getHeader("CamelJCacheKey"), entryProcessor, arguments));
            }
        }
        ,
        CLEAR{

            @Override
            void validate(Cache<Object, Object> cache, Exchange exchange) throws Exception {
            }

            @Override
            void execute(Cache<Object, Object> cache, Exchange exchange) {
                cache.clear();
            }
        };

        static final Action[] VALUES;

        static Action fromName(String name) {
            if (ObjectHelper.isNotEmpty(name)) {
                for (Action action : VALUES) {
                    if (!action.name().equalsIgnoreCase(name)) continue;
                    return action;
                }
            }
            return null;
        }

        void validate(Cache<Object, Object> cache, Exchange exchange) throws Exception {
        }

        void execute(Cache<Object, Object> cache, Exchange exchange) {
        }

        protected void headerIsNotNull(Exchange exchange, String ... keys) throws Exception {
            for (int i = keys.length - 1; i >= 0; --i) {
                if (exchange.getIn().getHeader(keys[i]) != null) continue;
                throw new IllegalArgumentException(String.format("Header %s must be set for action %s", keys[i], this.name()));
            }
        }

        static {
            VALUES = Action.values();
        }
    }
}

