/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.resume.ResumeStrategy;
import org.apache.camel.resume.ResumeStrategyConfiguration;
import org.apache.camel.resume.ResumeStrategyConfigurationBuilder;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="resumable")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ResumableDefinition
extends NoOutputDefinition<ResumableDefinition> {
    @XmlTransient
    private ResumeStrategy resumeStrategyBean;
    @XmlTransient
    private ResumeStrategyConfiguration resumeStrategyConfiguration;
    @XmlAttribute(required=true)
    @Metadata(required=true, javaType="org.apache.camel.resume.ResumeStrategy")
    private String resumeStrategy;
    @XmlAttribute
    @Metadata(label="advanced", javaType="org.apache.camel.LoggingLevel", defaultValue="ERROR", enums="TRACE,DEBUG,INFO,WARN,ERROR,OFF")
    private String loggingLevel;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", defaultValue="false")
    private String intermittent;

    public ResumableDefinition() {
    }

    protected ResumableDefinition(ResumableDefinition source) {
        super(source);
        this.resumeStrategyBean = source.resumeStrategyBean;
        this.resumeStrategyConfiguration = source.resumeStrategyConfiguration;
        this.resumeStrategy = source.resumeStrategy;
        this.loggingLevel = source.loggingLevel;
        this.intermittent = source.intermittent;
    }

    @Override
    public ResumableDefinition copyDefinition() {
        return new ResumableDefinition(this);
    }

    @Override
    public String getShortName() {
        return "resumable";
    }

    @Override
    public String getLabel() {
        return "resumable";
    }

    public ResumeStrategy getResumeStrategyBean() {
        return this.resumeStrategyBean;
    }

    public String getResumeStrategy() {
        return this.resumeStrategy;
    }

    public void setResumeStrategy(String resumeStrategy) {
        this.resumeStrategy = resumeStrategy;
    }

    public void setResumeStrategy(ResumeStrategy resumeStrategyBean) {
        this.resumeStrategyBean = resumeStrategyBean;
    }

    public String getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(String loggingLevelRef) {
        this.loggingLevel = loggingLevelRef;
    }

    public String getIntermittent() {
        return this.intermittent;
    }

    public void setIntermittent(String intermitent) {
        this.intermittent = intermitent;
    }

    public ResumeStrategyConfiguration getResumeStrategyConfiguration() {
        return this.resumeStrategyConfiguration;
    }

    public void setResumeStrategyConfiguration(ResumeStrategyConfiguration resumeStrategyConfiguration) {
        this.resumeStrategyConfiguration = resumeStrategyConfiguration;
    }

    public ResumableDefinition resumeStrategy(String resumeStrategyRef) {
        this.setResumeStrategy(resumeStrategyRef);
        return this;
    }

    public ResumableDefinition resumeStrategy(String resumeStrategyRef, String loggingLevelRef) {
        this.setResumeStrategy(resumeStrategyRef);
        this.setLoggingLevel(loggingLevelRef);
        return this;
    }

    public ResumableDefinition resumeStrategy(ResumeStrategy resumeStrategy) {
        this.setResumeStrategy(resumeStrategy);
        return this;
    }

    public ResumableDefinition resumeStrategy(ResumeStrategy resumeStrategy, String loggingLevelRef) {
        this.setResumeStrategy(resumeStrategy);
        this.setLoggingLevel(loggingLevelRef);
        return this;
    }

    public ResumableDefinition configuration(ResumeStrategyConfigurationBuilder<? extends ResumeStrategyConfigurationBuilder, ? extends ResumeStrategyConfiguration> builder) {
        this.setResumeStrategyConfiguration(builder.build());
        return this;
    }

    public ResumableDefinition intermittent(boolean intermittent) {
        this.setIntermittent(Boolean.toString(intermittent));
        return this;
    }
}

