/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.camel.Message;
import org.apache.camel.component.jetty.JettyHttpEndpoint;
import org.apache.camel.http.base.HttpHelper;
import org.apache.camel.http.common.DefaultHttpBinding;
import org.apache.camel.http.common.HttpCommonEndpoint;

public class JettyRestHttpBinding
extends DefaultHttpBinding {
    @Deprecated
    public JettyRestHttpBinding() {
    }

    public JettyRestHttpBinding(HttpCommonEndpoint ep) {
        super(ep);
        this.setHeaderFilterStrategy(ep.getHeaderFilterStrategy());
        this.setTransferException(ep.isTransferException());
        this.setEagerCheckContentAvailable(ep.isEagerCheckContentAvailable());
        this.setMapHttpMessageBody(ep.isMapHttpMessageBody());
        this.setMapHttpMessageHeaders(ep.isMapHttpMessageHeaders());
    }

    @Override
    protected void populateRequestParameters(HttpServletRequest request, Message message) {
        super.populateRequestParameters(request, message);
        String path = request.getPathInfo();
        if (path == null) {
            return;
        }
        JettyHttpEndpoint endpoint = (JettyHttpEndpoint)message.getExchange().getFromEndpoint();
        String consumerPath = endpoint.getPath();
        if (this.useRestMatching(consumerPath)) {
            HttpHelper.evalPlaceholders(message.getHeaders(), path, consumerPath);
        }
    }

    private boolean useRestMatching(String path) {
        return path.indexOf(123) > -1;
    }
}

