/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.HashMap;
import java.util.Map;
import org.jgroups.raft.StateMachine;
import org.jgroups.util.Bits;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.Util;

public class ReplStateMachine<K, V>
implements StateMachine {
    protected final Map<K, V> map = new HashMap();
    public static final int PUT = 1;
    public static final int REMOVE = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] apply(byte[] data, int offset, int length, boolean serialize_response) throws Exception {
        ByteArrayDataInputStream in = new ByteArrayDataInputStream(data, offset, length);
        byte command = in.readByte();
        switch (command) {
            case 1: {
                V old_val;
                Object key = Util.objectFromStream(in);
                Object val = Util.objectFromStream(in);
                Map<K, V> map = this.map;
                synchronized (map) {
                    old_val = this.map.put(key, val);
                }
                return old_val == null ? null : (serialize_response ? Util.objectToByteBuffer(old_val) : null);
            }
            case 2: {
                V old_val;
                Object key = Util.objectFromStream(in);
                Map<K, V> map = this.map;
                synchronized (map) {
                    old_val = this.map.remove(key);
                }
                return old_val == null ? null : (serialize_response ? Util.objectToByteBuffer(old_val) : null);
            }
        }
        throw new IllegalArgumentException("command " + command + " is unknown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readContentFrom(DataInput in) throws Exception {
        int size = Bits.readIntCompressed(in);
        HashMap tmp = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            Object key = Util.objectFromStream(in);
            Object val = Util.objectFromStream(in);
            tmp.put(key, val);
        }
        Map<K, V> map = this.map;
        synchronized (map) {
            this.map.putAll(tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeContentTo(DataOutput out) throws Exception {
        Map<K, V> map = this.map;
        synchronized (map) {
            int size = this.map.size();
            Bits.writeIntCompressed(size, out);
            for (Map.Entry<K, V> entry : this.map.entrySet()) {
                Util.objectToStream(entry.getKey(), out);
                Util.objectToStream(entry.getValue(), out);
            }
        }
    }
}

