/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jgroups.raft;

import org.apache.camel.Processor;
import org.apache.camel.component.jgroups.raft.CamelRoleChangeListener;
import org.apache.camel.component.jgroups.raft.JGroupsRaftEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsRaftConsumer
extends DefaultConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(JGroupsRaftConsumer.class);
    private final String clusterName;
    private boolean enableRoleChangeEvents;
    private final CamelRoleChangeListener roleListener;
    private final JGroupsRaftEndpoint endpoint;

    public JGroupsRaftConsumer(JGroupsRaftEndpoint endpoint, Processor processor, String clusterName, boolean enableRoleChangeEvents) {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.clusterName = clusterName;
        this.enableRoleChangeEvents = enableRoleChangeEvents;
        this.roleListener = new CamelRoleChangeListener(this, endpoint, processor);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.enableRoleChangeEvents) {
            LOG.debug("Connecting roleListener : {} to the cluster: {}.", (Object)this.roleListener, (Object)this.clusterName);
            this.endpoint.getResolvedRaftHandle().addRoleListener(this.roleListener);
        }
        this.endpoint.connect();
    }

    @Override
    protected void doStop() throws Exception {
        if (this.enableRoleChangeEvents) {
            LOG.debug("Closing connection to cluster: {} from roleListener: {}.", (Object)this.clusterName, (Object)this.roleListener);
            this.endpoint.getResolvedRaftHandle().removeRoleListener(this.roleListener);
        }
        this.endpoint.disconnect();
        super.doStop();
    }
}

