/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.perf;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.AtomicHistogram;
import org.HdrHistogram.Histogram;
import org.jgroups.blocks.atomic.AsyncCounter;
import org.jgroups.perf.CounterBenchmark;
import org.jgroups.perf.HistogramUtil;
import org.jgroups.raft.Options;
import org.jgroups.raft.blocks.RaftCounter;
import org.jgroups.util.CompletableFutures;

public class AsyncCounterBenchmark
implements CounterBenchmark {
    private List<CompletionStage<Void>> requests;
    private LongSupplier deltaSupplier;
    private int concurrency;
    private AsyncCounter counter;
    private final AtomicBoolean stop = new AtomicBoolean(false);
    private final LongAdder updates = new LongAdder();
    private final AtomicHistogram histogram = HistogramUtil.createAtomic();

    @Override
    public void init(int concurrency, ThreadFactory threadFactory, LongSupplier deltaSupplier, RaftCounter counter) {
        this.concurrency = concurrency;
        this.deltaSupplier = deltaSupplier;
        this.counter = counter.async().withOptions(Options.create(true));
        this.requests = new ArrayList<CompletionStage<Void>>(concurrency);
    }

    @Override
    public void start() {
        this.stop.set(false);
        long currentTime = System.nanoTime();
        for (int i = 0; i < this.concurrency; ++i) {
            this.requests.add(this.updateCounter());
        }
    }

    @Override
    public void stop() {
        this.stop.set(true);
    }

    @Override
    public void join() throws InterruptedException {
        for (CompletionStage<Void> stage : this.requests) {
            stage.toCompletableFuture().join();
        }
    }

    @Override
    public long getTotalUpdates() {
        return this.updates.sum();
    }

    @Override
    public Histogram getResults(boolean printUpdaters, Function<AbstractHistogram, String> timePrinter) {
        return this.histogram;
    }

    @Override
    public void close() throws Exception {
        this.stop.set(true);
        this.requests.clear();
    }

    private void updateTime(long timeNanos) {
        this.updates.increment();
        this.histogram.recordValue(timeNanos);
    }

    private CompletionStage<Long> updateCounter(CompletableFuture<Void> cf, CompletionStage<Long> prev, long start) {
        if (this.stop.get()) {
            cf.complete(null);
            return prev;
        }
        return prev.whenComplete((ignoreV, ignoreT) -> {
            long currentTime = System.nanoTime();
            this.updateTime(currentTime - start);
            long delta = this.deltaSupplier.getAsLong();
            this.updateCounter(cf, this.counter.addAndGet(delta), System.nanoTime());
        });
    }

    private CompletionStage<Void> updateCounter() {
        if (this.stop.get()) {
            return CompletableFutures.completedNull();
        }
        CompletableFuture<Void> cf = new CompletableFuture<Void>();
        this.updateCounter(cf, this.counter.addAndGet(this.deltaSupplier.getAsLong()), System.nanoTime());
        return cf;
    }
}

