/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.function.ObjLongConsumer;
import org.jgroups.Address;
import org.jgroups.protocols.raft.LogEntries;
import org.jgroups.protocols.raft.LogEntry;

public interface Log
extends Closeable {
    public void init(String var1, Map<String, String> var2) throws Exception;

    public Log useFsync(boolean var1);

    public boolean useFsync();

    public void delete() throws Exception;

    public long currentTerm();

    public Log currentTerm(long var1);

    public Address votedFor();

    public Log votedFor(Address var1);

    public long commitIndex();

    public Log commitIndex(long var1);

    public long firstAppended();

    public long lastAppended();

    public void setSnapshot(ByteBuffer var1);

    public ByteBuffer getSnapshot();

    public long append(long var1, LogEntries var3);

    public LogEntry get(long var1);

    public void truncate(long var1);

    public void reinitializeTo(long var1, LogEntry var3) throws Exception;

    public void deleteAllEntriesStartingFrom(long var1);

    public void forEach(ObjLongConsumer<LogEntry> var1, long var2, long var4);

    public void forEach(ObjLongConsumer<LogEntry> var1);

    default public long size() {
        long last = this.lastAppended();
        long first = this.firstAppended();
        return first == 0L ? last : last - first + 1L;
    }

    public long sizeInBytes();
}

