/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.concurrent.atomic.AtomicInteger;
import org.jgroups.protocols.raft.LogEntry;
import org.jgroups.raft.StateMachine;
import org.jgroups.util.Bits;

public class CounterStateMachine
implements StateMachine {
    protected final AtomicInteger counter = new AtomicInteger();
    protected final AtomicInteger additions = new AtomicInteger();
    protected final AtomicInteger subtractions = new AtomicInteger();

    public int counter() {
        return this.counter.get();
    }

    public int additions() {
        return this.additions.get();
    }

    public int subtractions() {
        return this.subtractions.get();
    }

    @Override
    public byte[] apply(byte[] data, int offset, int length, boolean serialize_response) throws Exception {
        int val = Bits.readInt(data, offset);
        if (val < 0) {
            this.subtractions.incrementAndGet();
        } else {
            this.additions.incrementAndGet();
        }
        int old_counter = this.counter.get();
        this.counter.addAndGet(val);
        if (!serialize_response) {
            return null;
        }
        byte[] retval = new byte[4];
        Bits.writeInt(old_counter, retval, 0);
        return retval;
    }

    public static String readAndDumpSnapshot(DataInput in) {
        try {
            int num = in.readInt();
            return String.valueOf(num);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String reader(LogEntry le) {
        byte[] buf = le.command();
        int offset = le.offset();
        int val = Bits.readInt(buf, offset);
        return String.valueOf(val);
    }

    @Override
    public void readContentFrom(DataInput in) throws Exception {
        int val = in.readInt();
        this.counter.set(val);
    }

    @Override
    public void writeContentTo(DataOutput out) throws Exception {
        out.writeInt(this.counter.get());
    }

    public CounterStateMachine reset() {
        this.counter.set(0);
        this.additions.set(0);
        this.subtractions.set(0);
        return this;
    }

    public String toString() {
        return String.format("counter=%d (%d additions %d subtractions)", this.counter.get(), this.additions.get(), this.subtractions.get());
    }
}

