/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jgroups.annotations.Component;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.Property;
import org.jgroups.annotations.Unsupported;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class PropsToAsciidoc {
    protected static final String ROOT_PACKAGE = "org.jgroups";

    public static void main(String[] args) {
        if (args.length != 1) {
            PropsToAsciidoc.help();
            System.err.println("args[0]=" + args[0]);
            return;
        }
        String prot_file = args[0];
        String temp_file = prot_file.replace("template", "generated");
        try {
            File f = new File(temp_file);
            PropsToAsciidoc.copy(new FileReader(prot_file), new FileWriter(f));
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Set<Class<?>> classes = Util.findClassesAssignableFrom("org.jgroups.protocols.raft", Protocol.class, cl);
            Properties props = new Properties();
            for (Class<?> clazz : classes) {
                PropsToAsciidoc.convertClassToAsciidocTable(props, clazz, null);
            }
            try (FileInputStream in = new FileInputStream(prot_file);
                 FileOutputStream out = new FileOutputStream(temp_file);){
                PropsToAsciidoc.replaceVariables(in, out, props);
            }
            props = new Properties();
            List<Class<?>> unsupportedClasses = Util.findClassesAnnotatedWith("org.jgroups.protocols.raft", Unsupported.class);
            PropsToAsciidoc.convertUnsupportedToAsciidocTable(props, unsupportedClasses, "Unsupported");
            List<Class<?>> experimentalClasses = Util.findClassesAnnotatedWith("org.jgroups.protocols.raft", Experimental.class);
            PropsToAsciidoc.convertUnsupportedToAsciidocTable(props, experimentalClasses, "Experimental");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void help() {
        System.out.println("PropsToAsciidoc <path to protocols-template.adoc file>");
    }

    protected static void convertUnsupportedToAsciidocTable(Properties props, List<Class<?>> clazzes, String title) throws ParserConfigurationException, TransformerException {
        ArrayList<String[]> rows = new ArrayList<String[]>(clazzes.size() + 1);
        rows.add(new String[]{"Package", "Class"});
        for (Class<?> clazz : clazzes) {
            rows.add(new String[]{clazz.getPackage().getName(), clazz.getSimpleName()});
        }
        String tmp = PropsToAsciidoc.createAsciidocTable(rows, title, "[align=\"left\",width=\"50%\",options=\"header\"]");
        if (clazzes.size() > 1) {
            props.put(title, tmp);
        }
    }

    protected static String createAsciidocTable(List<String[]> rows, String title, String header) throws ParserConfigurationException, TransformerException {
        StringBuilder sb = new StringBuilder(".").append(title).append("\n").append(header).append("\n").append("|=================\n");
        for (String[] row : rows) {
            for (String el : row) {
                sb.append("|").append(el);
            }
            sb.append("\n");
        }
        sb.append("|=================\n");
        return sb.toString();
    }

    private static void convertClassToAsciidocTable(Properties props, Class<?> clazz, String prefix) throws Exception {
        if (clazz.isAnnotationPresent(Unsupported.class)) {
            return;
        }
        TreeMap<String, String> nameToDescription = new TreeMap<String, String>();
        PropsToAsciidoc.getDescriptions(clazz, nameToDescription, prefix, false);
        if (nameToDescription.isEmpty()) {
            return;
        }
        ArrayList<String[]> rows = new ArrayList<String[]>(nameToDescription.size() + 1);
        rows.add(new String[]{"Name", "Description"});
        for (Map.Entry entry : nameToDescription.entrySet()) {
            rows.add(new String[]{(String)entry.getKey(), (String)entry.getValue()});
        }
        String tmp = PropsToAsciidoc.createAsciidocTable(rows, clazz.getSimpleName(), "[align=\"left\",width=\"90%\",cols=\"2,10\",options=\"header\"]");
        props.put(clazz.getSimpleName(), tmp);
    }

    protected static void getDescriptions(Class<?> clazz, Map<String, String> m, String prefix, boolean print_class) throws IOException, ClassNotFoundException {
        Property annotation;
        ArrayList<Field> fields = new ArrayList<Field>();
        PropsToAsciidoc.getAllFields(fields, clazz, Protocol.class);
        for (Field field : fields) {
            if (field.isAnnotationPresent(Property.class)) {
                Object property = field.getName();
                annotation = field.getAnnotation(Property.class);
                String name = annotation.name();
                if (name != null && !name.trim().isEmpty()) {
                    property = name.trim();
                }
                String desc = annotation.description();
                if (prefix != null && !prefix.isEmpty()) {
                    property = prefix + "." + (String)property;
                }
                if (print_class) {
                    property = String.format("%s (%s)", property, clazz.getSimpleName());
                }
                m.put((String)property, desc);
            }
            if (!field.isAnnotationPresent(Component.class)) continue;
            Component ann = field.getAnnotation(Component.class);
            Class<?> type = field.getType();
            if (type.isInterface() || Modifier.isAbstract(type.getModifiers())) {
                Set<Class<?>> implementations = Util.findClassesAssignableFrom(ROOT_PACKAGE, type, Thread.currentThread().getContextClassLoader());
                for (Class clazz2 : implementations) {
                    PropsToAsciidoc.getDescriptions(clazz2, m, ann.name(), true);
                }
                continue;
            }
            PropsToAsciidoc.getDescriptions(type, m, ann.name(), false);
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        PropsToAsciidoc.getAllMethods(methods, clazz, Protocol.class);
        for (Method method : methods) {
            Object name;
            if (!method.isAnnotationPresent(Property.class)) continue;
            annotation = method.getAnnotation(Property.class);
            String desc = annotation.description();
            if (desc == null || desc.isEmpty()) {
                desc = "n/a";
            }
            if (((String)(name = annotation.name())).length() < 1) {
                name = Util.methodNameToAttributeName(method.getName());
            }
            if (prefix != null && !prefix.isEmpty()) {
                name = prefix + "." + (String)name;
            }
            if (print_class) {
                name = String.format("%s (%s)", name, clazz.getSimpleName());
            }
            m.put((String)name, desc);
        }
    }

    private static void getAllFields(List<Field> fields, Class<?> clazz, Class<?> stop) {
        if (clazz.equals(stop)) {
            return;
        }
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        if (clazz.getSuperclass() != null) {
            PropsToAsciidoc.getAllFields(fields, clazz.getSuperclass(), stop);
        }
    }

    private static void getAllMethods(List<Method> methods, Class<?> clazz, Class<?> stop) {
        if (clazz.equals(stop)) {
            return;
        }
        methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        if (clazz.getSuperclass() != null) {
            PropsToAsciidoc.getAllMethods(methods, clazz.getSuperclass(), stop);
        }
    }

    protected static void replaceVariables(InputStream in, OutputStream out, Properties p) {
        boolean looping = true;
        block6: while (looping) {
            try {
                int ch = in.read();
                if (ch == -1) break;
                switch (ch) {
                    case 92: {
                        String s;
                        int n1 = in.read();
                        int n2 = in.read();
                        if (n1 == -1 || n2 == -1) {
                            looping = false;
                            if (n1 == -1) continue block6;
                            out.write(n1);
                            continue block6;
                        }
                        if (n1 == 36 && n2 == 123) {
                            s = PropsToAsciidoc.readUntilBracket(in);
                            out.write(n1);
                            out.write(n2);
                            out.write(s.getBytes());
                            out.write(125);
                            continue block6;
                        }
                        out.write(ch);
                        out.write(n1);
                        out.write(n2);
                        continue block6;
                    }
                    case 36: {
                        String s;
                        int n1 = in.read();
                        if (n1 == -1) {
                            out.write(ch);
                            looping = false;
                            continue block6;
                        }
                        if (n1 == 123) {
                            s = PropsToAsciidoc.readUntilBracket(in);
                            PropsToAsciidoc.writeVarToStream(s, p, out);
                            continue block6;
                        }
                        out.write(ch);
                        out.write(n1);
                        continue block6;
                    }
                }
                out.write(ch);
            }
            catch (IOException e) {
                // empty catch block
                break;
            }
        }
        Util.close(in, out);
    }

    protected static void writeVarToStream(String var, Properties p, OutputStream out) throws IOException {
        String val = (String)p.get(var);
        if (val != null) {
            out.write(val.getBytes());
        }
    }

    protected static String readUntilBracket(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        while (true) {
            int ch = in.read();
            switch (ch) {
                case -1: {
                    throw new EOFException("no matching } found");
                }
                case 125: {
                    return sb.toString();
                }
            }
            sb.append((char)ch);
        }
    }

    private static String fileToString(File f) throws Exception {
        StringWriter output = new StringWriter();
        FileReader input = new FileReader(f);
        char[] buffer = new char[8192];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(Reader input, Writer output) throws IOException {
        char[] buffer = new char[8192];
        int count = 0;
        int n = 0;
        try {
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += n;
            }
        }
        finally {
            output.flush();
            output.close();
        }
        return count;
    }
}

