/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.producer;

import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.IssueFieldId;
import com.atlassian.jira.rest.client.api.domain.IssueType;
import com.atlassian.jira.rest.client.api.domain.Priority;
import com.atlassian.jira.rest.client.api.domain.input.ComplexIssueInputFieldValue;
import com.atlassian.jira.rest.client.api.domain.input.FieldInput;
import com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;
import java.util.ArrayList;
import org.apache.camel.Exchange;
import org.apache.camel.component.jira.JiraEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

public class AddIssueProducer
extends DefaultProducer {
    public AddIssueProducer(JiraEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public void process(Exchange exchange) {
        JiraRestClient client = ((JiraEndpoint)this.getEndpoint()).getClient();
        String projectKey = exchange.getIn().getHeader("ProjectKey", String.class);
        Long issueTypeId = exchange.getIn().getHeader("IssueTypeId", Long.class);
        String issueTypeName = exchange.getIn().getHeader("IssueTypeName", String.class);
        String summary = exchange.getIn().getHeader("IssueSummary", String.class);
        String assigneeName = exchange.getIn().getHeader("IssueAssignee", String.class);
        String assigneeId = exchange.getIn().getHeader("IssueAssigneeId", String.class);
        String priorityName = exchange.getIn().getHeader("IssuePriorityName", String.class);
        Long priorityId = exchange.getIn().getHeader("IssuePriorityId", Long.class);
        String components = exchange.getIn().getHeader("IssueComponents", String.class);
        String watchers = exchange.getIn().getHeader("IssueWatchersAdd", String.class);
        if (issueTypeId == null && issueTypeName != null) {
            Iterable<IssueType> issueTypes = client.getMetadataClient().getIssueTypes().claim();
            for (IssueType type : issueTypes) {
                if (!issueTypeName.equals(type.getName())) continue;
                issueTypeId = type.getId();
                break;
            }
        }
        if (priorityId == null && priorityName != null) {
            Iterable<Priority> priorities = client.getMetadataClient().getPriorities().claim();
            for (Priority pri : priorities) {
                if (!priorityName.equals(pri.getName())) continue;
                priorityId = pri.getId();
                break;
            }
        }
        if (projectKey == null) {
            throw new IllegalArgumentException("A valid project key is required.");
        }
        if (issueTypeId == null) {
            throw new IllegalArgumentException("A valid issue type id is required, actual: id(null), name(" + issueTypeName + ")");
        }
        if (summary == null) {
            throw new IllegalArgumentException("A summary field is required.");
        }
        IssueInputBuilder builder = new IssueInputBuilder(projectKey, issueTypeId);
        builder.setDescription(exchange.getIn().getBody(String.class));
        builder.setSummary(summary);
        if (ObjectHelper.isNotEmpty(components)) {
            String[] compArr = components.split(",");
            ArrayList<String> comps = new ArrayList<String>(compArr.length);
            for (String s2 : compArr) {
                String c = s2.trim();
                if (c.isEmpty()) continue;
                comps.add(c);
            }
            builder.setComponentsNames(comps);
        }
        if (priorityId != null) {
            builder.setPriorityId(priorityId);
        }
        if (assigneeName != null) {
            builder.setAssigneeName(assigneeName);
        } else if (assigneeId != null) {
            builder.setFieldInput(new FieldInput(IssueFieldId.ASSIGNEE_FIELD, (Object)ComplexIssueInputFieldValue.with("id", assigneeId)));
        }
        IssueRestClient issueClient = client.getIssueClient();
        BasicIssue issueCreated = issueClient.createIssue(builder.build()).claim();
        Issue issue = issueClient.getIssue(issueCreated.getKey()).claim();
        if (ObjectHelper.isNotEmpty(watchers)) {
            String[] watArr;
            for (String s3 : watArr = watchers.split(",")) {
                String watcher = s3.trim();
                if (watcher.isEmpty()) continue;
                issueClient.addWatcher(issue.getWatchers().getSelf(), watcher);
            }
        }
        ExchangeHelper.setInOutBodyPatternAware(exchange, issue);
    }
}

