/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.consumer;

import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.domain.Comment;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.camel.Processor;
import org.apache.camel.component.jira.JiraEndpoint;
import org.apache.camel.component.jira.consumer.AbstractJiraConsumer;
import org.apache.camel.util.CastUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewCommentsConsumer
extends AbstractJiraConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(NewCommentsConsumer.class);
    private Long lastCommentId = -1L;

    public NewCommentsConsumer(JiraEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    @Override
    protected int doPoll() throws Exception {
        Queue<Comment> newComments = this.getComments();
        this.processBatch(CastUtils.cast(newComments));
        return newComments.size();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.getComments();
    }

    private Queue<Comment> getComments() {
        LOG.debug("Start: Jira NewCommentsConsumer: retrieving issue comments. Last comment id: {}", (Object)this.lastCommentId);
        IssueRestClient client = this.getEndpoint().getClient().getIssueClient();
        LinkedList newComments = this.getIssues().stream().map(issue -> client.getIssue(issue.getKey()).claim()).flatMap(issue -> StreamSupport.stream(issue.getComments().spliterator(), false)).filter(comment -> comment.getId() > this.lastCommentId).collect(Collectors.toCollection(LinkedList::new));
        Collections.reverse(newComments);
        this.lastCommentId = newComments.stream().mapToLong(Comment::getId).max().orElse(this.lastCommentId);
        LOG.debug("End: Jira NewCommentsConsumer: retrieving issue comments. {} new comments since last run.", (Object)newComments.size());
        return newComments;
    }
}

