/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.camel.Predicate;
import org.apache.camel.model.CatchDefinition;
import org.apache.camel.model.FinallyDefinition;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.spi.AsPredicate;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.DslProperty;

@Metadata(label="eip,routing,error")
@XmlRootElement(name="doTry")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TryDefinition
extends OutputDefinition<TryDefinition> {
    @DslProperty
    @XmlTransient
    private List<CatchDefinition> catchClauses;
    @DslProperty
    @XmlTransient
    private FinallyDefinition finallyClause;
    @XmlTransient
    private boolean initialized;
    @XmlTransient
    private List<ProcessorDefinition<?>> outputsWithoutCatches;
    @XmlTransient
    private int endCounter;

    public TryDefinition() {
    }

    protected TryDefinition(TryDefinition source) {
        super(source);
        this.catchClauses = ProcessorDefinitionHelper.deepCopyDefinitions(source.catchClauses);
        this.finallyClause = source.finallyClause != null ? source.finallyClause.copyDefinition() : null;
    }

    @Override
    public TryDefinition copyDefinition() {
        return new TryDefinition(this);
    }

    @Override
    public String toString() {
        return "DoTry[" + String.valueOf(this.getOutputs()) + "]";
    }

    @Override
    public String getShortName() {
        return "doTry";
    }

    @Override
    public String getLabel() {
        return "doTry";
    }

    public TryDefinition doCatch(Class<? extends Throwable> exceptionType) {
        return this.doCatch(new Class[]{exceptionType});
    }

    @SafeVarargs
    public final TryDefinition doCatch(Class<? extends Throwable> ... exceptionType) {
        this.popBlock();
        List<Class<? extends Throwable>> list = Arrays.asList(exceptionType);
        CatchDefinition answer = new CatchDefinition(list);
        this.addOutput(answer);
        this.pushBlock(answer);
        return this;
    }

    public TryDefinition doFinally() {
        this.popBlock();
        FinallyDefinition answer = new FinallyDefinition();
        this.addOutput(answer);
        this.pushBlock(answer);
        return this;
    }

    public TryDefinition onWhen(@AsPredicate Predicate predicate) {
        Collection<CatchDefinition> col = ProcessorDefinitionHelper.filterTypeInOutputs(this.getOutputs(), CatchDefinition.class);
        for (CatchDefinition doCatch : col) {
            doCatch.setOnWhen(new WhenDefinition(predicate));
        }
        return this;
    }

    @XmlTransient
    public void setCatchClauses(List<CatchDefinition> catchClauses) {
        this.catchClauses = catchClauses;
    }

    public List<CatchDefinition> getCatchClauses() {
        if (this.catchClauses == null) {
            this.checkInitialized();
        }
        return this.catchClauses;
    }

    @XmlTransient
    public void setFinallyClause(FinallyDefinition finallyClause) {
        this.finallyClause = finallyClause;
    }

    public FinallyDefinition getFinallyClause() {
        if (this.finallyClause == null) {
            this.checkInitialized();
        }
        return this.finallyClause;
    }

    public List<ProcessorDefinition<?>> getOutputsWithoutCatches() {
        if (this.outputsWithoutCatches == null) {
            this.checkInitialized();
        }
        return this.outputsWithoutCatches;
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return super.getOutputs();
    }

    @Override
    @XmlElementRef
    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        this.initialized = false;
        super.setOutputs(outputs);
    }

    @Override
    public void addOutput(ProcessorDefinition<?> output) {
        this.initialized = false;
        this.endCounter = 0;
        super.addOutput(output);
    }

    protected ProcessorDefinition<?> onEndDoTry() {
        if (this.endCounter > 0) {
            return this.end();
        }
        ++this.endCounter;
        return this;
    }

    @Override
    public void preCreateProcessor() {
        this.initialized = false;
        this.checkInitialized();
    }

    protected void checkInitialized() {
        if (!this.initialized) {
            this.initialized = true;
            this.outputsWithoutCatches = new ArrayList();
            if (this.catchClauses == null) {
                this.catchClauses = new ArrayList<CatchDefinition>();
            }
            int doFinallyCounter = 0;
            for (ProcessorDefinition output : this.outputs) {
                if (output instanceof CatchDefinition) {
                    CatchDefinition catchDefinition = (CatchDefinition)output;
                    if (this.catchClauses.contains(output)) continue;
                    this.catchClauses.add(catchDefinition);
                    continue;
                }
                if (output instanceof FinallyDefinition) {
                    FinallyDefinition finallyDefinition = (FinallyDefinition)output;
                    ++doFinallyCounter;
                    this.finallyClause = finallyDefinition;
                    continue;
                }
                this.outputsWithoutCatches.add(output);
            }
            if (doFinallyCounter > 1) {
                throw new IllegalArgumentException("Multiple finally clauses added: " + doFinallyCounter);
            }
            for (CatchDefinition cd2 : this.catchClauses) {
                cd2.setParent(this);
            }
            if (this.finallyClause != null) {
                this.finallyClause.setParent(this);
            }
        }
    }
}

