/*
 * Decompiled with CFR 0.152.
 */
package org.messaginghub.pooled.jms;

import jakarta.jms.Connection;
import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.JMSException;
import jakarta.jms.XAConnection;
import jakarta.jms.XAConnectionFactory;
import jakarta.jms.XAJMSContext;
import jakarta.transaction.TransactionManager;
import java.io.Serializable;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.spi.ObjectFactory;
import org.messaginghub.pooled.jms.JmsPoolConnection;
import org.messaginghub.pooled.jms.JmsPoolConnectionFactory;
import org.messaginghub.pooled.jms.JmsPoolXAJMSContext;
import org.messaginghub.pooled.jms.pool.PooledConnectionKey;
import org.messaginghub.pooled.jms.pool.PooledXAConnection;
import org.messaginghub.pooled.jms.util.IntrospectionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsPoolXAConnectionFactory
extends JmsPoolConnectionFactory
implements ObjectFactory,
Serializable,
XAConnectionFactory {
    private static final transient Logger LOG = LoggerFactory.getLogger(JmsPoolXAConnectionFactory.class);
    private static final long serialVersionUID = 7753681333583183646L;
    private TransactionManager transactionManager;
    private boolean tmFromJndi = false;
    private String tmJndiName = "java:/TransactionManager";

    public TransactionManager getTransactionManager() {
        block3: {
            if (this.transactionManager == null && this.tmFromJndi) {
                try {
                    this.transactionManager = (TransactionManager)new InitialContext().lookup(this.getTmJndiName());
                }
                catch (Throwable ignored) {
                    if (!LOG.isTraceEnabled()) break block3;
                    LOG.trace("exception on tmFromJndi: " + this.getTmJndiName(), ignored);
                }
            }
        }
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public void setConnectionFactory(Object toUse) {
        if (!(toUse instanceof XAConnectionFactory)) {
            throw new IllegalArgumentException("connectionFactory should implement jakarta.jms.XAConnectionFactory");
        }
        this.connectionFactory = toUse;
    }

    @Override
    protected XAConnection createProviderConnection(PooledConnectionKey key) throws JMSException {
        if (this.connectionFactory instanceof XAConnectionFactory) {
            if (key.getUserName() == null && key.getPassword() == null) {
                return ((XAConnectionFactory)this.connectionFactory).createXAConnection();
            }
            return ((XAConnectionFactory)this.connectionFactory).createXAConnection(key.getUserName(), key.getPassword());
        }
        throw new IllegalStateException("connectionFactory should implement jakarta.jms.XAConnectionFactory");
    }

    @Override
    protected XAJMSContext createProviderContext(String username, String password, int sessionMode) {
        if (this.connectionFactory instanceof XAConnectionFactory) {
            if (username == null && password == null) {
                return ((XAConnectionFactory)this.connectionFactory).createXAContext();
            }
            return ((XAConnectionFactory)this.connectionFactory).createXAContext(username, password);
        }
        throw new IllegalStateRuntimeException("connectionFactory should implement jakarta.jms.XAConnectionFactory");
    }

    @Override
    protected PooledXAConnection createPooledConnection(Connection connection) {
        return new PooledXAConnection(connection, this.getTransactionManager());
    }

    @Override
    protected JmsPoolXAJMSContext newPooledConnectionContext(JmsPoolConnection connection, int sessionMode) {
        return new JmsPoolXAJMSContext(connection, sessionMode);
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment2) throws Exception {
        this.setTmFromJndi(true);
        this.configFromJndiConf(obj);
        if (environment2 != null) {
            IntrospectionSupport.setProperties(this, environment2);
        }
        return this;
    }

    private void configFromJndiConf(Object rootContextName) {
        block4: {
            if (rootContextName instanceof String) {
                Object name = (String)rootContextName;
                name = ((String)name).substring(0, ((String)name).lastIndexOf(47)) + "/conf" + ((String)name).substring(((String)name).lastIndexOf(47));
                try {
                    InitialContext ctx = new InitialContext();
                    NamingEnumeration<Binding> bindings = ctx.listBindings((String)name);
                    while (bindings.hasMore()) {
                        Binding bd = bindings.next();
                        IntrospectionSupport.setProperty(this, bd.getName(), bd.getObject());
                    }
                }
                catch (Exception ignored) {
                    if (!LOG.isTraceEnabled()) break block4;
                    LOG.trace("exception on config from jndi: " + (String)name, (Throwable)ignored);
                }
            }
        }
    }

    public String getTmJndiName() {
        return this.tmJndiName;
    }

    public void setTmJndiName(String tmJndiName) {
        this.tmJndiName = tmJndiName;
    }

    public boolean isTmFromJndi() {
        return this.tmFromJndi;
    }

    public void setTmFromJndi(boolean tmFromJndi) {
        this.tmFromJndi = tmFromJndi;
    }

    @Override
    public XAConnection createXAConnection() throws JMSException {
        return this.createProviderConnection(new PooledConnectionKey(null, null));
    }

    @Override
    public XAConnection createXAConnection(String userName, String password) throws JMSException {
        return this.createProviderConnection(new PooledConnectionKey(userName, password));
    }

    @Override
    public XAJMSContext createXAContext() {
        return this.createProviderContext(null, null, 0);
    }

    @Override
    public XAJMSContext createXAContext(String userName, String password) {
        return this.createProviderContext(userName, password, 0);
    }
}

