/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jmx;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jmx.JMXEndpoint;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.PropertiesHelper;

@Component(value="jmx")
public class JMXComponent
extends DefaultComponent {
    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        JMXEndpoint endpoint = new JMXEndpoint(uri, this);
        PropertyBindingSupport.bindProperties(this.getCamelContext(), endpoint, parameters);
        endpoint.setServerURL(remaining);
        Map<String, Object> objectProperties = PropertiesHelper.extractProperties(parameters, "key.");
        if (!objectProperties.isEmpty()) {
            endpoint.setObjectProperties(objectProperties);
        }
        if (endpoint.getObjectDomain() == null) {
            throw new IllegalArgumentException("Must specify domain");
        }
        if (endpoint.getObjectName() == null && endpoint.getObjectProperties() == null) {
            throw new IllegalArgumentException("Must specify object name or object properties");
        }
        return endpoint;
    }
}

