/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.debugger;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.Predicate;
import org.apache.camel.impl.debugger.DefaultBacklogTracerEventMessage;
import org.apache.camel.spi.BacklogTracerEventMessage;
import org.apache.camel.spi.Language;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;

public final class BacklogTracer
extends ServiceSupport
implements org.apache.camel.spi.BacklogTracer {
    public static final int MAX_BACKLOG_SIZE = 1000;
    private final CamelContext camelContext;
    private final Language simple;
    private boolean enabled;
    private boolean standby;
    private final AtomicLong traceCounter = new AtomicLong();
    private final Queue<BacklogTracerEventMessage> queue = new LinkedBlockingQueue<BacklogTracerEventMessage>(1000);
    private int backlogSize = 100;
    private boolean removeOnDump = true;
    private int bodyMaxChars = 32768;
    private boolean bodyIncludeStreams;
    private boolean bodyIncludeFiles = true;
    private boolean includeExchangeProperties = true;
    private boolean includeExchangeVariables = true;
    private boolean includeException = true;
    private boolean traceRests;
    private boolean traceTemplates;
    private String tracePattern;
    private String[] patterns;
    private String traceFilter;
    private Predicate predicate;

    private BacklogTracer(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.simple = camelContext.resolveLanguage("simple");
    }

    public static BacklogTracer createTracer(CamelContext context) {
        return new BacklogTracer(context);
    }

    public boolean shouldTrace(NamedNode definition, Exchange exchange) {
        if (!this.enabled) {
            return false;
        }
        boolean pattern = true;
        boolean filter = true;
        if (this.patterns != null) {
            pattern = this.shouldTracePattern(definition);
        }
        if (this.predicate != null) {
            filter = this.shouldTraceFilter(exchange);
        }
        return pattern && filter;
    }

    private boolean shouldTracePattern(NamedNode definition) {
        for (String pattern : this.patterns) {
            String id = definition.getId();
            if (PatternHelper.matchPattern(id, pattern)) {
                return true;
            }
            String routeId = CamelContextHelper.getRouteId(definition);
            if (routeId == null || Objects.equals(routeId, id) || !PatternHelper.matchPattern(routeId, pattern)) continue;
            return true;
        }
        return false;
    }

    public void traceEvent(DefaultBacklogTracerEventMessage event) {
        if (!this.enabled) {
            return;
        }
        int drain = this.queue.size() - this.backlogSize + 1;
        if (drain > 0) {
            for (int i = 0; i < drain; ++i) {
                this.queue.poll();
            }
        }
        this.queue.add(event);
    }

    private boolean shouldTraceFilter(Exchange exchange) {
        return this.predicate.matches(exchange);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isStandby() {
        return this.standby;
    }

    @Override
    public void setStandby(boolean standby) {
        this.standby = standby;
    }

    @Override
    public int getBacklogSize() {
        return this.backlogSize;
    }

    @Override
    public void setBacklogSize(int backlogSize) {
        if (backlogSize <= 0) {
            throw new IllegalArgumentException("The backlog size must be a positive number, was: " + backlogSize);
        }
        if (backlogSize > 1000) {
            throw new IllegalArgumentException("The backlog size cannot be greater than the max size of 1000, was: " + backlogSize);
        }
        this.backlogSize = backlogSize;
    }

    @Override
    public boolean isRemoveOnDump() {
        return this.removeOnDump;
    }

    @Override
    public void setRemoveOnDump(boolean removeOnDump) {
        this.removeOnDump = removeOnDump;
    }

    @Override
    public int getBodyMaxChars() {
        return this.bodyMaxChars;
    }

    @Override
    public void setBodyMaxChars(int bodyMaxChars) {
        this.bodyMaxChars = bodyMaxChars;
    }

    @Override
    public boolean isBodyIncludeStreams() {
        return this.bodyIncludeStreams;
    }

    @Override
    public void setBodyIncludeStreams(boolean bodyIncludeStreams) {
        this.bodyIncludeStreams = bodyIncludeStreams;
    }

    @Override
    public boolean isBodyIncludeFiles() {
        return this.bodyIncludeFiles;
    }

    @Override
    public void setBodyIncludeFiles(boolean bodyIncludeFiles) {
        this.bodyIncludeFiles = bodyIncludeFiles;
    }

    @Override
    public boolean isIncludeExchangeProperties() {
        return this.includeExchangeProperties;
    }

    @Override
    public void setIncludeExchangeProperties(boolean includeExchangeProperties) {
        this.includeExchangeProperties = includeExchangeProperties;
    }

    @Override
    public boolean isIncludeExchangeVariables() {
        return this.includeExchangeVariables;
    }

    @Override
    public void setIncludeExchangeVariables(boolean includeExchangeVariables) {
        this.includeExchangeVariables = includeExchangeVariables;
    }

    @Override
    public boolean isIncludeException() {
        return this.includeException;
    }

    @Override
    public void setIncludeException(boolean includeException) {
        this.includeException = includeException;
    }

    @Override
    public boolean isTraceRests() {
        return this.traceRests;
    }

    @Override
    public void setTraceRests(boolean traceRests) {
        this.traceRests = traceRests;
    }

    @Override
    public boolean isTraceTemplates() {
        return this.traceTemplates;
    }

    @Override
    public void setTraceTemplates(boolean traceTemplates) {
        this.traceTemplates = traceTemplates;
    }

    @Override
    public String getTracePattern() {
        return this.tracePattern;
    }

    @Override
    public void setTracePattern(String tracePattern) {
        this.tracePattern = tracePattern;
        this.patterns = tracePattern != null ? tracePattern.split(",") : null;
    }

    @Override
    public String getTraceFilter() {
        return this.traceFilter;
    }

    @Override
    public void setTraceFilter(String filter) {
        this.traceFilter = filter;
        if (filter != null) {
            String name = StringHelper.before(filter, ":");
            this.predicate = name != null ? this.camelContext.resolveLanguage(name).createPredicate(filter) : this.simple.createPredicate(filter);
        }
    }

    @Override
    public long getTraceCounter() {
        return this.traceCounter.get();
    }

    @Override
    public long getQueueSize() {
        return this.queue.size();
    }

    @Override
    public void resetTraceCounter() {
        this.traceCounter.set(0L);
    }

    @Override
    public List<BacklogTracerEventMessage> dumpTracedMessages(String nodeId) {
        ArrayList<BacklogTracerEventMessage> answer = new ArrayList<BacklogTracerEventMessage>();
        if (nodeId != null) {
            for (BacklogTracerEventMessage message : this.queue) {
                if (!nodeId.equals(message.getToNode()) && !nodeId.equals(message.getRouteId())) continue;
                answer.add(message);
            }
        }
        if (this.removeOnDump) {
            this.queue.removeAll(answer);
        }
        return answer;
    }

    @Override
    public String dumpTracedMessagesAsXml(String nodeId) {
        List<BacklogTracerEventMessage> events = this.dumpTracedMessages(nodeId);
        return BacklogTracer.wrapAroundRootTag(events);
    }

    @Override
    public String dumpTracedMessagesAsJSon(String nodeId) {
        List<BacklogTracerEventMessage> events = this.dumpTracedMessages(nodeId);
        JsonObject root = new JsonObject();
        JsonArray arr = new JsonArray();
        root.put("traces", arr);
        for (BacklogTracerEventMessage event : events) {
            arr.add(event.asJSon());
        }
        return Jsoner.prettyPrint(root.toJson());
    }

    @Override
    public List<BacklogTracerEventMessage> dumpAllTracedMessages() {
        ArrayList<BacklogTracerEventMessage> answer = new ArrayList<BacklogTracerEventMessage>(this.queue);
        if (this.isRemoveOnDump()) {
            this.queue.clear();
        }
        return answer;
    }

    @Override
    public String dumpAllTracedMessagesAsXml() {
        List<BacklogTracerEventMessage> events = this.dumpAllTracedMessages();
        return BacklogTracer.wrapAroundRootTag(events);
    }

    private static String wrapAroundRootTag(List<BacklogTracerEventMessage> events) {
        StringBuilder sb = new StringBuilder(512);
        sb.append("<").append("backlogTracerEventMessage").append("s>");
        for (BacklogTracerEventMessage event : events) {
            sb.append("\n").append(event.toXml(2));
        }
        sb.append("\n</").append("backlogTracerEventMessage").append("s>");
        return sb.toString();
    }

    @Override
    public String dumpAllTracedMessagesAsJSon() {
        List<BacklogTracerEventMessage> events = this.dumpAllTracedMessages();
        JsonObject root = new JsonObject();
        JsonArray arr = new JsonArray();
        root.put("traces", arr);
        for (BacklogTracerEventMessage event : events) {
            arr.add(event.asJSon());
        }
        return Jsoner.prettyPrint(root.toJson());
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    public long incrementTraceCounter() {
        return this.traceCounter.incrementAndGet();
    }

    @Override
    protected void doStop() throws Exception {
        this.queue.clear();
    }
}

