/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Map;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedDynamicRouterMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.DynamicRouterDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.processor.DynamicRouter;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.URISupport;

@ManagedResource(description="Managed DynamicRouter")
public class ManagedDynamicRouter
extends ManagedProcessor
implements ManagedDynamicRouterMBean {
    private final DynamicRouter processor;
    private String uri;
    private boolean sanitize;

    public ManagedDynamicRouter(CamelContext context, DynamicRouter processor, DynamicRouterDefinition<?> definition) {
        super(context, processor, definition);
        this.processor = processor;
    }

    public DynamicRouterDefinition<?> getDefinition() {
        return (DynamicRouterDefinition)super.getDefinition();
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        this.sanitize = strategy.getManagementAgent().getMask() != null ? strategy.getManagementAgent().getMask() : true;
        this.uri = ((ExpressionNode)this.getDefinition()).getExpression().getExpression();
        if (this.sanitize) {
            this.uri = URISupport.sanitizeUri(this.uri);
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (this.processor.getEndpointUtilizationStatistics() != null) {
            this.processor.getEndpointUtilizationStatistics().clear();
        }
    }

    @Override
    public Boolean getSupportExtendedInformation() {
        return true;
    }

    @Override
    public String getExpression() {
        return this.uri;
    }

    @Override
    public String getExpressionLanguage() {
        return ((ExpressionNode)this.getDefinition()).getExpression().getLanguage();
    }

    @Override
    public String getUriDelimiter() {
        return this.processor.getUriDelimiter();
    }

    @Override
    public Integer getCacheSize() {
        return this.processor.getCacheSize();
    }

    @Override
    public Boolean isIgnoreInvalidEndpoints() {
        return this.processor.isIgnoreInvalidEndpoints();
    }

    @Override
    public TabularData extendedInformation() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.endpointsUtilizationTabularType());
            EndpointUtilizationStatistics stats = this.processor.getEndpointUtilizationStatistics();
            if (stats != null) {
                for (Map.Entry<String, Long> entry : stats.getStatistics().entrySet()) {
                    Long hits;
                    CompositeType ct = CamelOpenMBeanTypes.endpointsUtilizationCompositeType();
                    String url = entry.getKey();
                    if (this.sanitize) {
                        url = URISupport.sanitizeUri(url);
                    }
                    if ((hits = entry.getValue()) == null) {
                        hits = 0L;
                    }
                    CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"url", "hits"}, new Object[]{url, hits});
                    answer.put(data);
                }
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }
}

