/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.apache.camel.StaticService;
import org.apache.camel.Suspendable;
import org.apache.camel.SuspendableService;
import org.apache.camel.api.management.ManagedInstance;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedServiceMBean;
import org.apache.camel.spi.ManagementStrategy;

@ManagedResource(description="Managed Service")
public class ManagedService
implements ManagedInstance,
ManagedServiceMBean {
    private final CamelContext context;
    private final Service service;
    private Route route;

    public ManagedService(CamelContext context, Service service) {
        this.context = context;
        this.service = service;
    }

    public void init(ManagementStrategy strategy) {
    }

    @Override
    public boolean isStaticService() {
        return this.service instanceof StaticService;
    }

    public Service getService() {
        return this.service;
    }

    public CamelContext getContext() {
        return this.context;
    }

    public Route getRoute() {
        return this.route;
    }

    public void setRoute(Route route) {
        this.route = route;
    }

    @Override
    public String getState() {
        Service service = this.service;
        if (service instanceof StatefulService) {
            StatefulService statefulService = (StatefulService)service;
            ServiceStatus status = statefulService.getStatus();
            return status.name();
        }
        return ServiceStatus.Started.name();
    }

    @Override
    public String getCamelId() {
        return this.context.getName();
    }

    @Override
    public String getCamelManagementName() {
        return this.context.getManagementName();
    }

    @Override
    public String getRouteId() {
        if (this.route != null) {
            return this.route.getId();
        }
        return null;
    }

    @Override
    public String getServiceType() {
        if (this.service != null) {
            return this.service.getClass().getSimpleName();
        }
        return null;
    }

    @Override
    public void start() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.service.start();
    }

    @Override
    public void stop() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.service.stop();
    }

    @Override
    public boolean isSupportSuspension() {
        return this.service instanceof Suspendable && this.service instanceof SuspendableService;
    }

    @Override
    public boolean isSuspended() {
        Service service = this.service;
        if (service instanceof SuspendableService) {
            SuspendableService ss = (SuspendableService)service;
            return ss.isSuspended();
        }
        return false;
    }

    @Override
    public void suspend() throws Exception {
        Service service;
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        if (!(this.service instanceof Suspendable) || !((service = this.service) instanceof SuspendableService)) {
            throw new UnsupportedOperationException("suspend() is not a supported operation");
        }
        SuspendableService ss = (SuspendableService)service;
        ss.suspend();
    }

    @Override
    public void resume() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        Service service = this.service;
        if (!(service instanceof SuspendableService)) {
            throw new UnsupportedOperationException("resume() is not a supported operation");
        }
        SuspendableService ss = (SuspendableService)service;
        ss.resume();
    }

    @Override
    public Object getInstance() {
        return this.service;
    }
}

