/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.io.InputStream;
import java.util.ArrayDeque;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class RouteCoverageXmlParser {
    private RouteCoverageXmlParser() {
    }

    public static Document parseXml(final CamelContext camelContext, InputStream is) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/namespaces", false);
        factory.setFeature("http://xml.org/sax/features/validation", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        SAXParser parser = factory.newSAXParser();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbf.setFeature("http://xml.org/sax/features/namespaces", false);
        dbf.setFeature("http://xml.org/sax/features/validation", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        DocumentBuilder docBuilder = dbf.newDocumentBuilder();
        final Document doc = docBuilder.newDocument();
        final ArrayDeque elementStack = new ArrayDeque();
        final StringBuilder textBuffer = new StringBuilder();
        DefaultHandler handler = new DefaultHandler(){

            @Override
            public void setDocumentLocator(Locator locator) {
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                this.addTextIfNeeded();
                Element el = doc.createElement(qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    el.setAttribute(attributes.getQName(i), attributes.getValue(i));
                }
                String id = el.getAttribute("id");
                try {
                    if ("route".equals(qName)) {
                        ManagedRouteMBean route = camelContext.getCamelContextExtension().getContextPlugin(ManagedCamelContext.class).getManagedRoute(id);
                        if (route != null) {
                            long total = route.getExchangesTotal();
                            el.setAttribute("exchangesTotal", Long.toString(total));
                            long totalTime = route.getTotalProcessingTime();
                            el.setAttribute("totalProcessingTime", Long.toString(totalTime));
                        }
                    } else if ("from".equals(qName)) {
                        Element parent = (Element)elementStack.peek();
                        if (parent != null) {
                            String routeId = parent.getAttribute("id");
                            ManagedRouteMBean route = camelContext.getCamelContextExtension().getContextPlugin(ManagedCamelContext.class).getManagedRoute(routeId);
                            if (route != null) {
                                long total = route.getExchangesTotal();
                                el.setAttribute("exchangesTotal", Long.toString(total));
                                long totalTime = route.getTotalProcessingTime();
                                el.setAttribute("totalProcessingTime", Long.toString(totalTime));
                                el.setAttribute("index", "0");
                            }
                        }
                    } else {
                        ManagedProcessorMBean processor = camelContext.getCamelContextExtension().getContextPlugin(ManagedCamelContext.class).getManagedProcessor(id);
                        if (processor != null) {
                            long total = processor.getExchangesTotal();
                            el.setAttribute("exchangesTotal", Long.toString(total));
                            long totalTime = processor.getTotalProcessingTime();
                            el.setAttribute("totalProcessingTime", Long.toString(totalTime));
                            int index = processor.getIndex();
                            el.setAttribute("index", Integer.toString(index));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!"route".equals(qName)) {
                    el.removeAttribute("customId");
                }
                elementStack.push(el);
            }

            @Override
            public void endElement(String uri, String localName, String qName) {
                this.addTextIfNeeded();
                Element closedEl = (Element)elementStack.pop();
                if (elementStack.isEmpty()) {
                    doc.appendChild(closedEl);
                } else {
                    Element parentEl = (Element)elementStack.peek();
                    parentEl.appendChild(closedEl);
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                textBuffer.append(ch, start, length);
            }

            private void addTextIfNeeded() {
                if (!textBuffer.isEmpty()) {
                    Element el = (Element)elementStack.peek();
                    Text textNode = doc.createTextNode(textBuffer.toString());
                    el.appendChild(textNode);
                    textBuffer.delete(0, textBuffer.length());
                }
            }
        };
        parser.parse(is, handler);
        return doc;
    }
}

