/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.modifier.function;

import com.bazaarvoice.jolt.common.Optional;
import com.bazaarvoice.jolt.common.tree.WalkedPath;
import com.bazaarvoice.jolt.modifier.function.Function;
import com.bazaarvoice.jolt.modifier.function.FunctionArg;
import java.util.Map;

public class FunctionEvaluator {
    private final Function function;
    private final FunctionArg[] functionArgs;

    public static FunctionEvaluator forFunctionEvaluation(Function function, FunctionArg ... functionArgs) {
        return new FunctionEvaluator(function, functionArgs);
    }

    public static FunctionEvaluator forArgEvaluation(FunctionArg functionArgs) {
        return new FunctionEvaluator(null, functionArgs);
    }

    private FunctionEvaluator(Function function, FunctionArg ... functionArgs) {
        this.function = function;
        this.functionArgs = functionArgs;
    }

    public Optional<Object> evaluate(Optional<Object> inputOptional, WalkedPath walkedPath, Map<String, Object> context) {
        Optional<Object> valueOptional = Optional.empty();
        try {
            if (this.function == null) {
                valueOptional = this.functionArgs[0].evaluateArg(walkedPath, context);
            } else if (this.functionArgs.length == 1) {
                Optional<Object> evaluatedArgValue = this.functionArgs[0].evaluateArg(walkedPath, context);
                valueOptional = evaluatedArgValue.isPresent() ? this.function.apply(evaluatedArgValue.get()) : this.function.apply(new Object[0]);
            } else if (this.functionArgs.length > 1) {
                Object[] evaluatedArgs = FunctionEvaluator.evaluateArgsValue(this.functionArgs, context, walkedPath);
                valueOptional = this.function.apply(evaluatedArgs);
            } else {
                valueOptional = inputOptional.isPresent() ? this.function.apply(inputOptional.get()) : this.function.apply(new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return valueOptional;
    }

    private static Object[] evaluateArgsValue(FunctionArg[] functionArgs, Map<String, Object> context, WalkedPath walkedPath) {
        Object[] evaluatedArgs = new Object[functionArgs.length];
        for (int i = 0; i < functionArgs.length; ++i) {
            FunctionArg arg = functionArgs[i];
            Optional<Object> evaluatedValue = arg.evaluateArg(walkedPath, context);
            evaluatedArgs[i] = evaluatedValue.get();
        }
        return evaluatedArgs;
    }
}

