/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.modifier;

import com.bazaarvoice.jolt.common.Optional;
import com.bazaarvoice.jolt.common.tree.WalkedPath;
import com.bazaarvoice.jolt.modifier.OpMode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class DataType {
    private static final RUNTIME runtimeInstance = new RUNTIME();
    private static final MAP mapInstance = new MAP();

    public static DataType determineDataType(int confirmedArrayAtIndex, int confirmedMapAtIndex, int maxExplicitIndex) {
        if (confirmedArrayAtIndex > -1) {
            return new LIST(maxExplicitIndex);
        }
        if (confirmedMapAtIndex > -1) {
            return mapInstance;
        }
        return runtimeInstance;
    }

    public abstract boolean isCompatible(Object var1);

    protected abstract Object createValue();

    public Integer expand(Object source) {
        throw new RuntimeException("Expand not supported in " + this.getClass().getSimpleName() + " Type");
    }

    public Object create(String keyOrIndex, WalkedPath walkedPath, OpMode opMode) {
        Object parent = walkedPath.lastElement().getTreeRef();
        Optional<Integer> origSizeOptional = walkedPath.lastElement().getOrigSize();
        int index = -1;
        try {
            index = Integer.parseInt(keyOrIndex);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object value = null;
        if (parent instanceof Map && opMode.isApplicable((Map)parent, keyOrIndex)) {
            value = this.createValue();
            ((Map)parent).put(keyOrIndex, value);
        } else if (parent instanceof List && opMode.isApplicable((List)parent, index, origSizeOptional.get())) {
            value = this.createValue();
            ((List)parent).set(index, value);
        }
        return value;
    }

    public static final class RUNTIME
    extends DataType {
        @Override
        public boolean isCompatible(Object input) {
            return input != null;
        }

        @Override
        protected Object createValue() {
            throw new RuntimeException("Cannot create for RUNTIME Type");
        }
    }

    public static final class MAP
    extends DataType {
        @Override
        protected Object createValue() {
            return new LinkedHashMap();
        }

        @Override
        public boolean isCompatible(Object input) {
            return input == null || input instanceof Map;
        }
    }

    public static final class LIST
    extends DataType {
        private final int maxIndexFromSpec;

        private LIST(int maxIndexFromSpec) {
            this.maxIndexFromSpec = maxIndexFromSpec;
        }

        @Override
        protected Object createValue() {
            return new ArrayList();
        }

        @Override
        public Integer expand(Object input) {
            List source = (List)input;
            int reqIndex = this.maxIndexFromSpec;
            int currLastIndex = source.size() - 1;
            int origSize = currLastIndex + 1;
            if (reqIndex >= source.size()) {
                while (currLastIndex++ < reqIndex) {
                    source.add(null);
                }
            }
            return origSize;
        }

        @Override
        public boolean isCompatible(Object input) {
            return input == null || input instanceof List;
        }
    }
}

