/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.modifier.function;

import com.bazaarvoice.jolt.common.Optional;
import com.bazaarvoice.jolt.modifier.function.Function;
import com.bazaarvoice.jolt.modifier.function.Objects;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

public class Math {
    public static Optional<Number> max(List<Object> args) {
        if (args == null || args.size() == 0) {
            return Optional.empty();
        }
        Integer maxInt = Integer.MIN_VALUE;
        Double maxDouble = -1.7976931348623157E308;
        Long maxLong = Long.MIN_VALUE;
        boolean found = false;
        for (Object arg : args) {
            Optional<? extends Number> optional;
            if (arg instanceof Integer) {
                maxInt = java.lang.Math.max(maxInt, (Integer)arg);
                found = true;
                continue;
            }
            if (arg instanceof Double) {
                maxDouble = java.lang.Math.max(maxDouble, (Double)arg);
                found = true;
                continue;
            }
            if (arg instanceof Long) {
                maxLong = java.lang.Math.max(maxLong, (Long)arg);
                found = true;
                continue;
            }
            if (!(arg instanceof String) || !(optional = Objects.toNumber(arg)).isPresent()) continue;
            arg = optional.get();
            if (arg instanceof Integer) {
                maxInt = java.lang.Math.max(maxInt, (Integer)arg);
                found = true;
                continue;
            }
            if (arg instanceof Double) {
                maxDouble = java.lang.Math.max(maxDouble, (Double)arg);
                found = true;
                continue;
            }
            if (!(arg instanceof Long)) continue;
            maxLong = java.lang.Math.max(maxLong, (Long)arg);
            found = true;
        }
        if (!found) {
            return Optional.empty();
        }
        if (maxInt.longValue() >= maxDouble.longValue() && maxInt.longValue() >= maxLong) {
            return Optional.of(maxInt);
        }
        if (maxLong >= maxDouble.longValue()) {
            return Optional.of(maxLong);
        }
        return Optional.of(maxDouble);
    }

    public static Optional<Number> min(List<Object> args) {
        if (args == null || args.size() == 0) {
            return Optional.empty();
        }
        Integer minInt = Integer.MAX_VALUE;
        Double minDouble = Double.MAX_VALUE;
        Long minLong = Long.MAX_VALUE;
        boolean found = false;
        for (Object arg : args) {
            Optional<? extends Number> optional;
            if (arg instanceof Integer) {
                minInt = java.lang.Math.min(minInt, (Integer)arg);
                found = true;
                continue;
            }
            if (arg instanceof Double) {
                minDouble = java.lang.Math.min(minDouble, (Double)arg);
                found = true;
                continue;
            }
            if (arg instanceof Long) {
                minLong = java.lang.Math.min(minLong, (Long)arg);
                found = true;
                continue;
            }
            if (!(arg instanceof String) || !(optional = Objects.toNumber(arg)).isPresent()) continue;
            arg = optional.get();
            if (arg instanceof Integer) {
                minInt = java.lang.Math.min(minInt, (Integer)arg);
                found = true;
                continue;
            }
            if (arg instanceof Double) {
                minDouble = java.lang.Math.min(minDouble, (Double)arg);
                found = true;
                continue;
            }
            if (!(arg instanceof Long)) continue;
            minLong = java.lang.Math.min(minLong, (Long)arg);
            found = true;
        }
        if (!found) {
            return Optional.empty();
        }
        if (minInt.longValue() <= minDouble.longValue() && minInt.longValue() <= minLong) {
            return Optional.of(minInt);
        }
        if (minLong <= minDouble.longValue()) {
            return Optional.of(minLong);
        }
        return Optional.of(minDouble);
    }

    public static Optional<Number> abs(Object arg) {
        if (arg instanceof Integer) {
            return Optional.of(java.lang.Math.abs((Integer)arg));
        }
        if (arg instanceof Double) {
            return Optional.of(java.lang.Math.abs((Double)arg));
        }
        if (arg instanceof Long) {
            return Optional.of(java.lang.Math.abs((Long)arg));
        }
        if (arg instanceof String) {
            return Math.abs(Objects.toNumber(arg).get());
        }
        return Optional.empty();
    }

    public static Optional<Double> avg(List<Object> args) {
        double sum = 0.0;
        int count = 0;
        for (Object arg : args) {
            Optional<? extends Number> numberOptional = Objects.toNumber(arg);
            if (!numberOptional.isPresent()) continue;
            sum += numberOptional.get().doubleValue();
            ++count;
        }
        return count == 0 ? Optional.empty() : Optional.of(sum / (double)count);
    }

    public static Optional<Integer> intSum(List<Object> args) {
        Integer sum = 0;
        for (Object arg : args) {
            Optional<Integer> numberOptional = Objects.toInteger(arg);
            if (!numberOptional.isPresent()) continue;
            sum = sum + numberOptional.get();
        }
        return Optional.of(sum);
    }

    public static Optional<Double> doubleSum(List<Object> args) {
        Double sum = 0.0;
        for (Object arg : args) {
            Optional<Double> numberOptional = Objects.toDouble(arg);
            if (!numberOptional.isPresent()) continue;
            sum = sum + numberOptional.get();
        }
        return Optional.of(sum);
    }

    public static Optional<Long> longSum(List<Object> args) {
        Long sum = 0L;
        for (Object arg : args) {
            Optional<Long> numberOptional = Objects.toLong(arg);
            if (!numberOptional.isPresent()) continue;
            sum = sum + numberOptional.get();
        }
        return Optional.of(sum);
    }

    public static Optional<Integer> intSubtract(List<Object> argList) {
        if (argList == null || argList.size() != 2) {
            return Optional.empty();
        }
        if (!(argList.get(0) instanceof Integer) || !(argList.get(1) instanceof Integer)) {
            return Optional.empty();
        }
        int a = (Integer)argList.get(0);
        int b = (Integer)argList.get(1);
        return Optional.of(a - b);
    }

    public static Optional<Double> doubleSubtract(List<Object> argList) {
        if (argList == null || argList.size() != 2) {
            return Optional.empty();
        }
        if (!(argList.get(0) instanceof Double) || !(argList.get(1) instanceof Double)) {
            return Optional.empty();
        }
        double a = (Double)argList.get(0);
        double b = (Double)argList.get(1);
        return Optional.of(a - b);
    }

    public static Optional<Long> longSubtract(List<Object> argList) {
        if (argList == null || argList.size() != 2) {
            return Optional.empty();
        }
        if (!(argList.get(0) instanceof Long) || !(argList.get(1) instanceof Long)) {
            return Optional.empty();
        }
        long a = (Long)argList.get(0);
        long b = (Long)argList.get(1);
        return Optional.of(a - b);
    }

    public static Optional<Double> divide(List<Object> argList) {
        if (argList == null || argList.size() != 2) {
            return Optional.empty();
        }
        Optional<? extends Number> numerator = Objects.toNumber(argList.get(0));
        Optional<? extends Number> denominator = Objects.toNumber(argList.get(1));
        if (numerator.isPresent() && denominator.isPresent()) {
            Double drDoubleValue = denominator.get().doubleValue();
            if (drDoubleValue == 0.0) {
                return Optional.empty();
            }
            Double nrDoubleValue = numerator.get().doubleValue();
            Double result = nrDoubleValue / drDoubleValue;
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public static Optional<Double> divideAndRound(List<Object> argList, int digitsAfterDecimalPoint) {
        Optional<Double> divideResult = Math.divide(argList);
        if (divideResult.isPresent()) {
            Double divResult = divideResult.get();
            BigDecimal bigDecimal = new BigDecimal(divResult).setScale(digitsAfterDecimalPoint, RoundingMode.HALF_UP);
            return Optional.of(bigDecimal.doubleValue());
        }
        return Optional.empty();
    }

    public static final class longSubtract
    extends Function.ListFunction {
        @Override
        protected Optional<Object> applyList(List<Object> argLongList) {
            return Math.longSubtract(argLongList);
        }
    }

    public static final class doubleSubtract
    extends Function.ListFunction {
        @Override
        protected Optional<Object> applyList(List<Object> argDoubleList) {
            return Math.doubleSubtract(argDoubleList);
        }
    }

    public static final class intSubtract
    extends Function.ListFunction {
        @Override
        protected Optional<Object> applyList(List<Object> argIntList) {
            return Math.intSubtract(argIntList);
        }
    }

    public static final class longSum
    extends Function.ListFunction {
        @Override
        protected Optional<Object> applyList(List<Object> argLongList) {
            return Math.longSum(argLongList);
        }
    }

    public static final class doubleSum
    extends Function.ListFunction {
        @Override
        protected Optional<Object> applyList(List<Object> argDoubleList) {
            return Math.doubleSum(argDoubleList);
        }
    }

    public static final class intSum
    extends Function.ListFunction {
        @Override
        protected Optional<Object> applyList(List<Object> argIntList) {
            return Math.intSum(argIntList);
        }
    }

    public static final class avg
    extends Function.ListFunction {
        @Override
        protected Optional<Object> applyList(List<Object> argList) {
            return Math.avg(argList);
        }
    }

    public static final class divideAndRound
    extends Function.ArgDrivenListFunction<Integer> {
        @Override
        protected Optional<Object> applyList(Integer digitsAfterDecimalPoint, List<Object> args) {
            return Math.divideAndRound(args, digitsAfterDecimalPoint);
        }
    }

    public static final class divide
    extends Function.ListFunction {
        @Override
        protected Optional<Object> applyList(List<Object> argList) {
            return Math.divide(argList);
        }
    }

    public static final class abs
    extends Function.SingleFunction<Number> {
        @Override
        protected Optional<Number> applySingle(Object arg) {
            return Math.abs(arg);
        }
    }

    public static final class min
    extends Function.BaseFunction<Object> {
        @Override
        protected Optional<Object> applyList(List<Object> argList) {
            return Math.min(argList);
        }

        @Override
        protected Optional<Object> applySingle(Object arg) {
            if (arg instanceof Number) {
                return Optional.of(arg);
            }
            return Optional.empty();
        }
    }

    public static final class max
    extends Function.BaseFunction<Object> {
        @Override
        protected Optional<Object> applyList(List argList) {
            return Math.max(argList);
        }

        @Override
        protected Optional<Object> applySingle(Object arg) {
            if (arg instanceof Number) {
                return Optional.of(arg);
            }
            return Optional.empty();
        }
    }
}

